/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.smartboot.socket.buffer.BufferPagePool;
import org.smartboot.socket.buffer.VirtualBuffer;
import org.smartboot.socket.channels.AsynchronousSocketChannelProxy;
import org.smartboot.socket.enhance.EnhanceAsynchronousChannelProvider;
import org.smartboot.socket.extension.ssl.HandshakeCompletionHandler;
import org.smartboot.socket.extension.ssl.HandshakeModel;
import org.smartboot.socket.extension.ssl.SslService;

public class SslAsynchronousSocketChannel
extends AsynchronousSocketChannelProxy {
    private final VirtualBuffer netWriteBuffer;
    private final VirtualBuffer netReadBuffer;
    private final VirtualBuffer appReadBuffer;
    private SSLEngine sslEngine = null;
    private final HandshakeModel handshakeModel;
    private final SslService sslService;
    private boolean handshake = true;
    private CountDownLatch handshakeLatch = new CountDownLatch(1);
    private int adaptiveWriteSize = -1;
    private boolean closed = false;

    public SslAsynchronousSocketChannel(AsynchronousSocketChannel asynchronousSocketChannel, SslService sslService, BufferPagePool bufferPage) {
        super(asynchronousSocketChannel);
        this.handshakeModel = sslService.createSSLEngine(asynchronousSocketChannel, bufferPage);
        this.sslService = sslService;
        this.sslEngine = this.handshakeModel.getSslEngine();
        this.netWriteBuffer = this.handshakeModel.getNetWriteBuffer();
        this.netReadBuffer = this.handshakeModel.getNetReadBuffer();
        this.appReadBuffer = this.handshakeModel.getAppReadBuffer();
    }

    @Override
    public <A> void read(final ByteBuffer dst, final long timeout, final TimeUnit unit, final A attachment, final CompletionHandler<Integer, ? super A> handler) {
        if (this.handshake) {
            this.handshakeModel.setHandshakeCompletionHandler(new HandshakeCompletionHandler(){

                private void release(HandshakeModel model) {
                    model.getAppWriteBuffer().clean();
                    model.getNetReadBuffer().buffer().flip();
                    model.getNetWriteBuffer().buffer().clear();
                    model.getAppReadBuffer().buffer().clear().flip();
                }

                @Override
                public void completed(HandshakeModel model) {
                    if (!SslAsynchronousSocketChannel.this.handshake) {
                        return;
                    }
                    this.release(model);
                    SslAsynchronousSocketChannel.this.handshake = false;
                    SslAsynchronousSocketChannel.this.handshakeLatch.countDown();
                    SslAsynchronousSocketChannel.this.read(dst, timeout, unit, attachment, handler);
                }

                @Override
                public void failed(Throwable exc, HandshakeModel model) {
                    if (!SslAsynchronousSocketChannel.this.handshake) {
                        return;
                    }
                    this.release(model);
                    SslAsynchronousSocketChannel.this.handshake = false;
                    SslAsynchronousSocketChannel.this.handshakeLatch.countDown();
                    handler.failed(exc, attachment);
                }
            });
            this.sslService.doHandshake(this.handshakeModel);
            return;
        }
        ByteBuffer appBuffer = this.appReadBuffer.buffer();
        if (appBuffer.hasRemaining()) {
            this.handleAppBuffer(dst, attachment, handler, appBuffer);
            return;
        }
        final ByteBuffer netBuffer = this.netReadBuffer.buffer();
        if (netBuffer.hasRemaining()) {
            appBuffer.compact();
            try {
                this.doUnWrap(netBuffer, appBuffer);
            }
            catch (SSLException e) {
                handler.failed(e, attachment);
            }
            appBuffer.flip();
        }
        if (appBuffer.hasRemaining()) {
            this.handleAppBuffer(dst, attachment, handler, appBuffer);
            return;
        }
        netBuffer.compact();
        this.asynchronousSocketChannel.read(netBuffer, timeout, unit, attachment, new CompletionHandler<Integer, A>(){

            @Override
            public void completed(Integer result, A attachment) {
                if (result == -2) {
                    return;
                }
                if (result == -3) {
                    SslAsynchronousSocketChannel.this.asynchronousSocketChannel.read(netBuffer, timeout, unit, attachment, this);
                    return;
                }
                if (result == -1) {
                    handler.completed(result, attachment);
                    return;
                }
                ByteBuffer appBuffer = SslAsynchronousSocketChannel.this.appReadBuffer.buffer();
                if (appBuffer.hasRemaining()) {
                    this.failed(new IOException("\u89e3\u5305\u7b97\u6cd5\u5f02\u5e38..."), attachment);
                    return;
                }
                appBuffer.clear();
                ByteBuffer netBuffer2 = SslAsynchronousSocketChannel.this.netReadBuffer.buffer();
                netBuffer2.flip();
                try {
                    SslAsynchronousSocketChannel.this.doUnWrap(netBuffer2, appBuffer);
                }
                catch (SSLException e) {
                    handler.failed(e, attachment);
                }
                appBuffer.flip();
                if (appBuffer.hasRemaining()) {
                    SslAsynchronousSocketChannel.this.handleAppBuffer(dst, attachment, handler, appBuffer);
                } else {
                    netBuffer2.compact();
                    SslAsynchronousSocketChannel.this.asynchronousSocketChannel.read(netBuffer2, timeout, unit, attachment, this);
                }
            }

            @Override
            public void failed(Throwable exc, A attachment) {
                handler.failed(exc, attachment);
            }
        });
    }

    private <A> void handleAppBuffer(ByteBuffer dst, A attachment, CompletionHandler<Integer, ? super A> handler, ByteBuffer appBuffer) {
        int pos = dst.position();
        if (appBuffer.remaining() > dst.remaining()) {
            int limit = appBuffer.limit();
            appBuffer.limit(appBuffer.position() + dst.remaining());
            dst.put(appBuffer);
            appBuffer.limit(limit);
        } else {
            dst.put(appBuffer);
        }
        handler.completed(dst.position() - pos, attachment);
    }

    private void doUnWrap(ByteBuffer netBuffer, ByteBuffer appBuffer) throws SSLException {
        SSLEngineResult result;
        while ((result = this.sslEngine.unwrap(netBuffer, appBuffer)).getStatus() == SSLEngineResult.Status.OK && netBuffer.hasRemaining() && appBuffer.hasRemaining()) {
        }
    }

    @Override
    public Future<Integer> read(ByteBuffer dst) {
        CompletableFuture<Integer> readFuture = new CompletableFuture<Integer>();
        EnhanceAsynchronousChannelProvider.SYNC_READ_FLAG.set(true);
        try {
            this.read(dst, 0L, TimeUnit.MILLISECONDS, readFuture, EnhanceAsynchronousChannelProvider.SYNC_READ_HANDLER);
        }
        finally {
            EnhanceAsynchronousChannelProvider.SYNC_READ_FLAG.set(false);
        }
        return readFuture;
    }

    @Override
    public <A> void read(ByteBuffer[] dsts, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A> void write(final ByteBuffer src, final long timeout, final TimeUnit unit, A attachment, final CompletionHandler<Integer, ? super A> handler) {
        if (this.handshake) {
            try {
                this.handshakeLatch.await();
            }
            catch (InterruptedException e) {
                handler.failed(e, attachment);
                return;
            }
        }
        final int pos = src.position();
        try {
            this.doWrap(src);
        }
        catch (SSLException e) {
            handler.failed(e, attachment);
            return;
        }
        if (src.position() - pos == 0) {
            if (this.sslEngine.getSession().isValid()) {
                System.err.println("write error:" + src + " netWrite:" + this.netWriteBuffer.buffer());
            } else {
                handler.failed(new IOException("connections is closed"), attachment);
                return;
            }
        }
        this.asynchronousSocketChannel.write(this.netWriteBuffer.buffer(), timeout, unit, attachment, new CompletionHandler<Integer, A>(){

            @Override
            public void completed(Integer result, A attachment) {
                if (result == -1) {
                    System.err.println("aaaaaaaaaaa");
                }
                if (SslAsynchronousSocketChannel.this.netWriteBuffer.buffer().hasRemaining()) {
                    SslAsynchronousSocketChannel.this.asynchronousSocketChannel.write(SslAsynchronousSocketChannel.this.netWriteBuffer.buffer(), timeout, unit, attachment, this);
                } else {
                    SslAsynchronousSocketChannel.this.netWriteBuffer.buffer().clear();
                    handler.completed(src.position() - pos, attachment);
                }
            }

            @Override
            public void failed(Throwable exc, A attachment) {
                handler.failed(exc, attachment);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitialized() {
        if (!this.handshake) {
            return;
        }
        SslAsynchronousSocketChannel sslAsynchronousSocketChannel = this;
        synchronized (sslAsynchronousSocketChannel) {
            if (!this.handshake) {
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void doWrap(ByteBuffer writeBuffer) throws SSLException {
        ByteBuffer netBuffer = this.netWriteBuffer.buffer();
        if (netBuffer.position() > 0) {
            throw new IllegalStateException("netBuffer.position() > 0");
        }
        int limit = writeBuffer.limit();
        if (this.adaptiveWriteSize > 0 && writeBuffer.remaining() > this.adaptiveWriteSize) {
            writeBuffer.limit(writeBuffer.position() + this.adaptiveWriteSize);
        }
        SSLEngineResult result = this.sslEngine.wrap(writeBuffer, netBuffer);
        while (result.getStatus() != SSLEngineResult.Status.OK) {
            switch (result.getStatus()) {
                case BUFFER_OVERFLOW: {
                    netBuffer.clear();
                    writeBuffer.limit(writeBuffer.position() + (writeBuffer.limit() - writeBuffer.position() >> 1));
                    this.adaptiveWriteSize = writeBuffer.remaining();
                    break;
                }
                case BUFFER_UNDERFLOW: {
                    if (!this.sslService.isDebug()) break;
                    System.err.println("doWrap BUFFER_UNDERFLOW");
                    break;
                }
                case CLOSED: {
                    throw new SSLException("SSLEngine has " + (Object)((Object)result.getStatus()));
                }
                default: {
                    if (!this.sslService.isDebug()) break;
                    System.out.println("doWrap Result:" + (Object)((Object)result.getStatus()));
                }
            }
            result = this.sslEngine.wrap(writeBuffer, netBuffer);
        }
        writeBuffer.limit(limit);
        netBuffer.flip();
    }

    @Override
    public Future<Integer> write(ByteBuffer src) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A> void write(ByteBuffer[] srcs, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.netWriteBuffer.clean();
        this.netReadBuffer.clean();
        this.appReadBuffer.clean();
        try {
            this.sslEngine.closeInbound();
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
        this.sslEngine.closeOutbound();
        this.asynchronousSocketChannel.close();
    }
}

