/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.action.mappings;

import java.util.Arrays;
import org.aesh.readline.InputProcessor;
import org.aesh.readline.action.mappings.MovementAction;
import org.aesh.readline.editing.EditMode;
import org.aesh.readline.util.Parser;

abstract class ChangeAction
extends MovementAction {
    private EditMode.Status status;
    protected boolean viMode;

    ChangeAction(EditMode.Status status) {
        this.status = status;
        this.viMode = false;
    }

    ChangeAction(boolean viMode, EditMode.Status status) {
        this.status = status;
        this.viMode = viMode;
    }

    protected EditMode.Status getStatus() {
        return this.status;
    }

    protected final void apply(int cursor, InputProcessor inputProcessor) {
        this.apply(cursor, inputProcessor.buffer().buffer().cursor(), inputProcessor);
    }

    protected final void apply(int cursor, int oldCursor, InputProcessor inputProcessor) {
        String word;
        if (this.status == EditMode.Status.DELETE || this.status == EditMode.Status.CHANGE) {
            inputProcessor.buffer().addActionToUndoStack();
            if (cursor < oldCursor) {
                inputProcessor.buffer().pasteManager().addText(Arrays.copyOfRange(inputProcessor.buffer().buffer().multiLine(), cursor, oldCursor));
                inputProcessor.buffer().delete(cursor - oldCursor);
            } else {
                inputProcessor.buffer().pasteManager().addText(Arrays.copyOfRange(inputProcessor.buffer().buffer().multiLine(), oldCursor, cursor));
                inputProcessor.buffer().delete(cursor - oldCursor);
            }
            if (this.viMode && this.status == EditMode.Status.DELETE && oldCursor == inputProcessor.buffer().buffer().length()) {
                inputProcessor.buffer().moveCursor(-1);
            }
        } else if (this.status == EditMode.Status.MOVE) {
            inputProcessor.buffer().moveCursor(cursor - oldCursor);
        } else if (this.status == EditMode.Status.YANK) {
            if (cursor < oldCursor) {
                inputProcessor.buffer().pasteManager().addText(Arrays.copyOfRange(inputProcessor.buffer().buffer().multiLine(), cursor, oldCursor));
            } else if (cursor > oldCursor) {
                inputProcessor.buffer().pasteManager().addText(Arrays.copyOfRange(inputProcessor.buffer().buffer().multiLine(), oldCursor, cursor));
            }
        } else if (this.status == EditMode.Status.UP_CASE) {
            if (cursor < oldCursor) {
                inputProcessor.buffer().addActionToUndoStack();
                for (int i = cursor; i < oldCursor; ++i) {
                    inputProcessor.buffer().upCase();
                }
            } else {
                inputProcessor.buffer().addActionToUndoStack();
                for (int i = oldCursor; i < cursor; ++i) {
                    inputProcessor.buffer().upCase();
                }
            }
            inputProcessor.buffer().moveCursor(cursor - oldCursor);
        } else if (this.status == EditMode.Status.DOWN_CASE) {
            if (cursor < oldCursor) {
                inputProcessor.buffer().addActionToUndoStack();
                for (int i = cursor; i < oldCursor; ++i) {
                    inputProcessor.buffer().downCase();
                }
            } else {
                inputProcessor.buffer().addActionToUndoStack();
                for (int i = oldCursor; i < cursor; ++i) {
                    inputProcessor.buffer().downCase();
                }
            }
            inputProcessor.buffer().moveCursor(cursor - oldCursor);
        } else if (this.status == EditMode.Status.CAPITALIZE && (word = Parser.findWordClosestToCursor(inputProcessor.buffer().buffer().asString(), oldCursor)).length() > 0) {
            inputProcessor.buffer().addActionToUndoStack();
            int pos = inputProcessor.buffer().buffer().asString().indexOf(word, oldCursor - word.length());
            if (pos < 0) {
                pos = 0;
            }
            inputProcessor.buffer().upCase();
            inputProcessor.buffer().moveCursor(cursor - oldCursor);
        }
    }
}

