/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.guice;

import com.google.inject.Binder;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Names;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.google.inject.util.Types;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.guice.ShiroMatchers;
import org.apache.shiro.guice.ShiroModule;

class BeanTypeListener
implements TypeListener {
    public static final Package SHIRO_GUICE_PACKAGE = ShiroModule.class.getPackage();
    public static final Package SHIRO_PACKAGE = SecurityUtils.class.getPackage();
    private static Matcher<Class> shiroMatcher = Matchers.inSubpackage((String)SHIRO_PACKAGE.getName());
    private static Matcher<Class> shiroGuiceMatcher = Matchers.inSubpackage((String)SHIRO_GUICE_PACKAGE.getName());
    private static Matcher<Class> classMatcher = ShiroMatchers.ANY_PACKAGE.and(shiroMatcher.and(Matchers.not(shiroGuiceMatcher)));
    public static final Matcher<TypeLiteral> MATCHER = ShiroMatchers.typeLiteral(classMatcher);
    private static final String BEAN_TYPE_MAP_NAME = "__SHIRO_BEAN_TYPES__";
    static final Key<?> MAP_KEY = Key.get((Type)Types.mapOf(TypeLiteral.class, BeanTypeKey.class), (Annotation)Names.named((String)"__SHIRO_BEAN_TYPES__"));
    private static final Set<Class<?>> WRAPPER_TYPES = new HashSet<Class>(Arrays.asList(Byte.class, Boolean.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, Void.class));

    BeanTypeListener() {
    }

    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors((Class)type.getRawType());
        final HashMap propertyDependencies = new HashMap(propertyDescriptors.length);
        final Provider injectorProvider = encounter.getProvider(Injector.class);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (propertyDescriptor.getWriteMethod() == null || !Modifier.isPublic(propertyDescriptor.getWriteMethod().getModifiers())) continue;
            Type propertyType = propertyDescriptor.getWriteMethod().getGenericParameterTypes()[0];
            propertyDependencies.put(propertyDescriptor, BeanTypeListener.createDependencyKey(propertyDescriptor, propertyType));
        }
        encounter.register(new MembersInjector<I>(){

            public void injectMembers(I instance) {
                for (Map.Entry dependency : propertyDependencies.entrySet()) {
                    try {
                        Injector injector = (Injector)injectorProvider.get();
                        Object value = injector.getInstance(BeanTypeListener.getMappedKey(injector, (Key)dependency.getValue()));
                        ((PropertyDescriptor)dependency.getKey()).getWriteMethod().invoke(instance, value);
                    }
                    catch (ConfigurationException injector) {
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException("Couldn't set property " + ((PropertyDescriptor)dependency.getKey()).getDisplayName(), e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("We shouldn't have ever reached this point, we don't try to inject to non-accessible methods.", e);
                    }
                }
            }
        });
    }

    private static Key<?> getMappedKey(Injector injector, Key<?> key) {
        Map<TypeLiteral, BeanTypeKey> beanTypeMap = BeanTypeListener.getBeanTypeMap(injector);
        if (key.getAnnotation() == null && beanTypeMap.containsKey(key.getTypeLiteral())) {
            return beanTypeMap.get((Object)key.getTypeLiteral()).key;
        }
        return key;
    }

    private static Map<TypeLiteral, BeanTypeKey> getBeanTypeMap(Injector injector) {
        return (Map)injector.getInstance(MAP_KEY);
    }

    private static Key<?> createDependencyKey(PropertyDescriptor propertyDescriptor, Type propertyType) {
        if (BeanTypeListener.requiresName(propertyType)) {
            return Key.get((Type)propertyType, (Annotation)Names.named((String)("shiro." + propertyDescriptor.getName())));
        }
        return Key.get((Type)propertyType);
    }

    private static boolean requiresName(Type propertyType) {
        if (propertyType instanceof Class) {
            Class aClass = (Class)propertyType;
            return aClass.isPrimitive() || aClass.isEnum() || WRAPPER_TYPES.contains(aClass) || CharSequence.class.isAssignableFrom(aClass);
        }
        return false;
    }

    static void ensureBeanTypeMapExists(Binder binder) {
        BeanTypeListener.beanTypeMapBinding(binder).addBinding((Object)TypeLiteral.get(BeanTypeKey.class)).toInstance((Object)new BeanTypeKey(null));
    }

    static <T> void bindBeanType(Binder binder, TypeLiteral<T> typeLiteral, Key<? extends T> key) {
        BeanTypeListener.beanTypeMapBinding(binder).addBinding(typeLiteral).toInstance((Object)new BeanTypeKey(key));
    }

    private static MapBinder<TypeLiteral, BeanTypeKey> beanTypeMapBinding(Binder binder) {
        return MapBinder.newMapBinder((Binder)binder, TypeLiteral.class, BeanTypeKey.class, (Annotation)Names.named((String)BEAN_TYPE_MAP_NAME));
    }

    private static class BeanTypeKey {
        Key<?> key;

        private BeanTypeKey(Key<?> key) {
            this.key = key;
        }
    }
}

