/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthSchemeRegistry;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Krb5HttpClientConfigurer
extends HttpClientConfigurer {
    public static final String LOGIN_CONFIG_PROP = "java.security.auth.login.config";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Configuration jaasConfig = new SolrJaasConfiguration();
    private HttpRequestInterceptor bufferedEntityInterceptor = new HttpRequestInterceptor(){

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            if (request instanceof HttpEntityEnclosingRequest) {
                HttpEntityEnclosingRequest enclosingRequest = (HttpEntityEnclosingRequest)request;
                HttpEntity requestEntity = enclosingRequest.getEntity();
                enclosingRequest.setEntity((HttpEntity)new BufferedHttpEntity(requestEntity));
            }
        }
    };

    @Override
    public void configure(DefaultHttpClient httpClient, SolrParams config) {
        super.configure(httpClient, config);
        if (System.getProperty(LOGIN_CONFIG_PROP) != null) {
            String configValue = System.getProperty(LOGIN_CONFIG_PROP);
            if (configValue != null) {
                logger.info("Setting up SPNego auth with config: " + configValue);
                String useSubjectCredsProp = "javax.security.auth.useSubjectCredsOnly";
                String useSubjectCredsVal = System.getProperty("javax.security.auth.useSubjectCredsOnly");
                if (useSubjectCredsVal == null) {
                    System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                } else if (!useSubjectCredsVal.toLowerCase(Locale.ROOT).equals("false")) {
                    logger.warn("System Property: javax.security.auth.useSubjectCredsOnly set to: " + useSubjectCredsVal + " not false.  SPNego authentication may not be successful.");
                }
                Configuration.setConfiguration(jaasConfig);
                AuthSchemeRegistry registry = new AuthSchemeRegistry();
                registry.register("Negotiate", (AuthSchemeFactory)new SPNegoSchemeFactory(true, false));
                httpClient.setAuthSchemes(registry);
                Credentials useJaasCreds = new Credentials(){

                    public String getPassword() {
                        return null;
                    }

                    public Principal getUserPrincipal() {
                        return null;
                    }
                };
                httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, useJaasCreds);
                httpClient.addRequestInterceptor(this.bufferedEntityInterceptor);
            } else {
                httpClient.getCredentialsProvider().clear();
            }
        }
    }

    private static class SolrJaasConfiguration
    extends Configuration {
        private Configuration baseConfig;
        private Set<String> initiateAppNames = new HashSet<String>(Arrays.asList("com.sun.security.jgss.krb5.initiate", "com.sun.security.jgss.initiate"));

        public SolrJaasConfiguration() {
            try {
                this.baseConfig = Configuration.getConfiguration();
            }
            catch (SecurityException e) {
                this.baseConfig = null;
            }
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            if (this.baseConfig == null) {
                return null;
            }
            logger.debug("Login prop: " + System.getProperty(Krb5HttpClientConfigurer.LOGIN_CONFIG_PROP));
            String clientAppName = System.getProperty("solr.kerberos.jaas.appname", "Client");
            if (this.initiateAppNames.contains(appName)) {
                logger.debug("Using AppConfigurationEntry for appName '" + clientAppName + "' instead of: " + appName);
                return this.baseConfig.getAppConfigurationEntry(clientAppName);
            }
            return this.baseConfig.getAppConfigurationEntry(appName);
        }
    }
}

