/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.site;

import java.io.File;
import java.nio.file.Path;
import javax.inject.Singleton;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SiteBaseDirResolver {
    private static final Logger logger = LoggerFactory.getLogger(SiteBaseDirResolver.class);
    private static final String DEFAULT_SOURCE_LOCATION = "src/site";

    File resolveBaseDir(File mavenBaseDir, Xpp3Dom siteConfig) {
        String siteDirectory = SiteBaseDirResolver.resolveSiteDirectory(siteConfig);
        String locale = SiteBaseDirResolver.resolveLocale(siteConfig);
        Path path = Path.of(mavenBaseDir.getPath(), new String[0]);
        if (siteDirectory != null && locale != null) {
            return SiteBaseDirResolver.normalize(path, siteDirectory, locale);
        }
        if (siteDirectory != null) {
            return SiteBaseDirResolver.normalize(path, siteDirectory);
        }
        if (locale != null) {
            return SiteBaseDirResolver.normalize(path, DEFAULT_SOURCE_LOCATION, locale);
        }
        return SiteBaseDirResolver.normalize(path, DEFAULT_SOURCE_LOCATION);
    }

    private static String resolveSiteDirectory(Xpp3Dom siteConfig) {
        Xpp3Dom siteDirectoryNode;
        if (siteConfig != null && (siteDirectoryNode = siteConfig.getChild("siteDirectory")) != null) {
            return siteDirectoryNode.getValue();
        }
        return null;
    }

    private static String resolveLocale(Xpp3Dom siteConfig) {
        Xpp3Dom locales;
        if (siteConfig != null && (locales = siteConfig.getChild("locales")) != null) {
            String[] split = locales.getValue().split(",");
            if (split.length > 0) {
                logger.warn("Multiple locales found: {}, this is not supported. Configure multiple plugin executions instead.", (Object)locales.getValue());
            }
            return split[0];
        }
        return null;
    }

    private static File normalize(Path path, String ... other) {
        for (String value : other) {
            path = path.resolve(value);
        }
        return path.normalize().toFile();
    }
}

