/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.site;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.project.MavenProject;
import org.asciidoctor.Attributes;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.maven.commons.AsciidoctorHelper;
import org.asciidoctor.maven.commons.StringUtils;
import org.asciidoctor.maven.site.SiteBaseDirResolver;
import org.asciidoctor.maven.site.SiteConversionConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Singleton
public class SiteConversionConfigurationParser {
    private final SiteBaseDirResolver siteBaseDirResolver;

    @Inject
    public SiteConversionConfigurationParser(SiteBaseDirResolver siteBaseDirResolver) {
        this.siteBaseDirResolver = siteBaseDirResolver;
    }

    public SiteConversionConfiguration processAsciiDocConfig(MavenProject mavenProject, String roleHint) {
        AttributesBuilder presetAttributes = this.defaultAttributes();
        AsciidoctorHelper.addProperties(mavenProject.getProperties(), presetAttributes);
        Attributes attributes = presetAttributes.build();
        File siteDir = this.siteBaseDirResolver.resolveBaseDir(mavenProject.getBasedir(), this.getSiteConfig(mavenProject));
        OptionsBuilder presetOptions = this.defaultOptions(siteDir, roleHint);
        Xpp3Dom asciidocConfig = Optional.ofNullable(this.getSiteConfig(mavenProject)).map(node -> node.getChild("asciidoc")).orElse(null);
        if (asciidocConfig == null) {
            Options options = presetOptions.attributes(attributes).build();
            return new SiteConversionConfiguration(null, siteDir, options, Collections.emptyList());
        }
        ArrayList<String> gemsToRequire = new ArrayList<String>();
        for (Xpp3Dom asciidocOpt : asciidocConfig.getChildren()) {
            String optName = asciidocOpt.getName();
            if ("requires".equals(optName)) {
                Xpp3Dom[] requires = asciidocOpt.getChildren("require");
                if (requires.length <= 0) continue;
                Xpp3Dom[] xpp3DomArray = requires;
                int n = xpp3DomArray.length;
                for (int i = 0; i < n; ++i) {
                    Xpp3Dom requireNode = xpp3DomArray[i];
                    if (requireNode.getValue().contains(",")) {
                        Stream.of(requireNode.getValue().split(",")).filter(StringUtils::isNotBlank).map(String::trim).forEach(value -> gemsToRequire.add((String)value));
                        continue;
                    }
                    String value2 = requireNode.getValue();
                    if (!StringUtils.isNotBlank(value2)) continue;
                    gemsToRequire.add(value2.trim());
                }
                continue;
            }
            if ("attributes".equals(optName)) {
                for (Xpp3Dom asciidocAttr : asciidocOpt.getChildren()) {
                    AsciidoctorHelper.addAttribute(asciidocAttr.getName(), asciidocAttr.getValue(), presetAttributes);
                }
                continue;
            }
            if ("templateDirs".equals(optName) || "template_dirs".equals(optName)) {
                List<File> dirs = Arrays.stream(asciidocOpt.getChildren("dir")).filter(node -> StringUtils.isNotBlank(node.getValue())).map(node -> this.resolveProjectDir(mavenProject, node.getValue())).collect(Collectors.toList());
                presetOptions.templateDirs(dirs.toArray(new File[dirs.size()]));
                continue;
            }
            if ("baseDir".equals(optName)) {
                presetOptions.baseDir(this.resolveProjectDir(mavenProject, asciidocOpt.getValue()));
                continue;
            }
            presetOptions.option(optName.replaceAll("(?<!_)([A-Z])", "_$1").toLowerCase(), (Object)asciidocOpt.getValue());
        }
        Options options = presetOptions.attributes(attributes).build();
        return new SiteConversionConfiguration(asciidocConfig, siteDir, options, gemsToRequire);
    }

    private Xpp3Dom getSiteConfig(MavenProject mavenProject) {
        return mavenProject.getGoalConfiguration("org.apache.maven.plugins", "maven-site-plugin", "site", "site");
    }

    private File resolveProjectDir(MavenProject mavenProject, String path) {
        File filePath = new File(path);
        return !filePath.isAbsolute() ? new File(mavenProject.getBasedir(), filePath.toString()).getAbsoluteFile() : filePath;
    }

    private OptionsBuilder defaultOptions(File siteDirectory, String roleHint) {
        return Options.builder().backend("xhtml").safe(SafeMode.UNSAFE).baseDir(new File(siteDirectory, roleHint).getAbsoluteFile());
    }

    private AttributesBuilder defaultAttributes() {
        return Attributes.builder().attribute("idprefix", (Object)"@").attribute("showtitle", (Object)"@");
    }
}

