/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.datasource.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.alibaba.sentinel.datasource.config.AbstractDataSourceProperties;
import org.springframework.cloud.alibaba.sentinel.datasource.config.ApolloDataSourceProperties;
import org.springframework.cloud.alibaba.sentinel.datasource.config.FileDataSourceProperties;
import org.springframework.cloud.alibaba.sentinel.datasource.config.NacosDataSourceProperties;
import org.springframework.cloud.alibaba.sentinel.datasource.config.ZookeeperDataSourceProperties;
import org.springframework.util.ObjectUtils;

public class DataSourcePropertiesConfiguration {
    private FileDataSourceProperties file;
    private NacosDataSourceProperties nacos;
    private ZookeeperDataSourceProperties zk;
    private ApolloDataSourceProperties apollo;

    public DataSourcePropertiesConfiguration() {
    }

    public DataSourcePropertiesConfiguration(FileDataSourceProperties file) {
        this.file = file;
    }

    public DataSourcePropertiesConfiguration(NacosDataSourceProperties nacos) {
        this.nacos = nacos;
    }

    public DataSourcePropertiesConfiguration(ZookeeperDataSourceProperties zk) {
        this.zk = zk;
    }

    public DataSourcePropertiesConfiguration(ApolloDataSourceProperties apollo) {
        this.apollo = apollo;
    }

    public FileDataSourceProperties getFile() {
        return this.file;
    }

    public void setFile(FileDataSourceProperties file) {
        this.file = file;
    }

    public NacosDataSourceProperties getNacos() {
        return this.nacos;
    }

    public void setNacos(NacosDataSourceProperties nacos) {
        this.nacos = nacos;
    }

    public ZookeeperDataSourceProperties getZk() {
        return this.zk;
    }

    public void setZk(ZookeeperDataSourceProperties zk) {
        this.zk = zk;
    }

    public ApolloDataSourceProperties getApollo() {
        return this.apollo;
    }

    public void setApollo(ApolloDataSourceProperties apollo) {
        this.apollo = apollo;
    }

    @JsonIgnore
    public List<String> getValidField() {
        ArrayList<String> fieldList = new ArrayList<String>();
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                if (ObjectUtils.isEmpty((Object)field.get(this))) continue;
                fieldList.add(field.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return fieldList;
    }

    @JsonIgnore
    public AbstractDataSourceProperties getValidDataSourceProperties() {
        List<String> invalidFields = this.getValidField();
        if (invalidFields.size() == 1) {
            try {
                this.getClass().getDeclaredField(invalidFields.get(0)).setAccessible(true);
                return (AbstractDataSourceProperties)this.getClass().getDeclaredField(invalidFields.get(0)).get(this);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return null;
    }
}

