/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.datasource.converter;

import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.slots.block.AbstractRule;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleUtil;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class XmlConverter
implements Converter<String, List<AbstractRule>> {
    private static final Logger logger = LoggerFactory.getLogger(XmlConverter.class);
    private final XmlMapper xmlMapper;

    public XmlConverter(XmlMapper xmlMapper) {
        this.xmlMapper = xmlMapper;
    }

    public List<AbstractRule> convert(String source) {
        ArrayList<AbstractRule> ruleList = new ArrayList<AbstractRule>();
        if (StringUtils.isEmpty((Object)source)) {
            logger.warn("Sentinel XmlConverter can not convert rules because source is empty");
            return ruleList;
        }
        try {
            List xmlArray = (List)this.xmlMapper.readValue(source, (TypeReference)new TypeReference<List<HashMap>>(){});
            for (Object obj : xmlArray) {
                String itemXml = null;
                try {
                    itemXml = this.xmlMapper.writeValueAsString(obj);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
                List<AbstractRule> rules = Arrays.asList(this.convertFlowRule(itemXml), this.convertDegradeRule(itemXml), this.convertSystemRule(itemXml), this.convertAuthorityRule(itemXml), this.convertParamFlowRule(itemXml));
                ArrayList<AbstractRule> convertRuleList = new ArrayList<AbstractRule>();
                for (AbstractRule rule : rules) {
                    if (ObjectUtils.isEmpty((Object)rule)) continue;
                    convertRuleList.add(rule);
                }
                if (convertRuleList.size() == 0) {
                    logger.warn("Sentinel XmlConverter can not convert {} to any rules, ignore", (Object)itemXml);
                    continue;
                }
                if (convertRuleList.size() > 1) {
                    logger.warn("Sentinel XmlConverter convert {} and match multi rules, ignore", (Object)itemXml);
                    continue;
                }
                ruleList.add((AbstractRule)convertRuleList.get(0));
            }
            if (xmlArray.size() != ruleList.size()) {
                logger.warn("Sentinel XmlConverter Source list size is not equals to Target List, maybe a part of xml is invalid. Source List: " + xmlArray + ", Target List: " + ruleList);
            }
        }
        catch (Exception e) {
            logger.error("Sentinel XmlConverter convert error: " + e.getMessage());
            throw new RuntimeException("Sentinel XmlConverter convert error: " + e.getMessage(), e);
        }
        return ruleList;
    }

    private FlowRule convertFlowRule(String xml) {
        try {
            FlowRule rule = (FlowRule)this.xmlMapper.readValue(xml, FlowRule.class);
            if (FlowRuleUtil.isValidRule((FlowRule)rule)) {
                return rule;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private DegradeRule convertDegradeRule(String xml) {
        try {
            DegradeRule rule = (DegradeRule)this.xmlMapper.readValue(xml, DegradeRule.class);
            if (DegradeRuleManager.isValidRule((DegradeRule)rule)) {
                return rule;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private SystemRule convertSystemRule(String xml) {
        SystemRule rule = null;
        try {
            rule = (SystemRule)this.xmlMapper.readValue(xml, SystemRule.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rule;
    }

    private AuthorityRule convertAuthorityRule(String xml) {
        AuthorityRule rule = null;
        try {
            rule = (AuthorityRule)this.xmlMapper.readValue(xml, AuthorityRule.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rule;
    }

    private ParamFlowRule convertParamFlowRule(String json) {
        ParamFlowRule rule = null;
        try {
            rule = (ParamFlowRule)this.xmlMapper.readValue(json, ParamFlowRule.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rule;
    }
}

