/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisServer;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.convert.ListConverter;
import org.springframework.data.redis.connection.convert.MapConverter;
import org.springframework.data.redis.connection.convert.SetConverter;
import org.springframework.data.redis.connection.convert.StringToRedisClientInfoConverter;
import org.springframework.data.redis.connection.jedis.JedisExceptionConverter;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.util.SafeEncoder;

public abstract class JedisConverters
extends Converters {
    private static final Converter<String, byte[]> STRING_TO_BYTES;
    private static final ListConverter<String, byte[]> STRING_LIST_TO_BYTE_LIST;
    private static final SetConverter<String, byte[]> STRING_SET_TO_BYTE_SET;
    private static final MapConverter<String, byte[]> STRING_MAP_TO_BYTE_MAP;
    private static final SetConverter<Tuple, RedisZSetCommands.Tuple> TUPLE_SET_TO_TUPLE_SET;
    private static final Converter<Exception, DataAccessException> EXCEPTION_CONVERTER;
    private static final Converter<String[], List<RedisClientInfo>> STRING_TO_CLIENT_INFO_CONVERTER;
    private static final Converter<Tuple, RedisZSetCommands.Tuple> TUPLE_CONVERTER;
    private static final ListConverter<Tuple, RedisZSetCommands.Tuple> TUPLE_LIST_TO_TUPLE_LIST_CONVERTER;
    private static final Converter<Object, RedisClusterNode> OBJECT_TO_CLUSTER_NODE_CONVERTER;
    private static final Converter<Expiration, byte[]> EXPIRATION_TO_COMMAND_OPTION_CONVERTER;
    private static final Converter<RedisStringCommands.SetOption, byte[]> SET_OPTION_TO_COMMAND_OPTION_CONVERTER;
    private static final Converter<List<String>, Long> STRING_LIST_TO_TIME_CONVERTER;
    public static final byte[] PLUS_BYTES;
    public static final byte[] MINUS_BYTES;
    public static final byte[] POSITIVE_INFINITY_BYTES;
    public static final byte[] NEGATIVE_INFINITY_BYTES;
    private static final byte[] EX;
    private static final byte[] PX;
    private static final byte[] NX;
    private static final byte[] XX;

    public static Converter<String, byte[]> stringToBytes() {
        return STRING_TO_BYTES;
    }

    public static ListConverter<Tuple, RedisZSetCommands.Tuple> tuplesToTuples() {
        return TUPLE_LIST_TO_TUPLE_LIST_CONVERTER;
    }

    public static ListConverter<String, byte[]> stringListToByteList() {
        return STRING_LIST_TO_BYTE_LIST;
    }

    public static SetConverter<String, byte[]> stringSetToByteSet() {
        return STRING_SET_TO_BYTE_SET;
    }

    public static MapConverter<String, byte[]> stringMapToByteMap() {
        return STRING_MAP_TO_BYTE_MAP;
    }

    public static SetConverter<Tuple, RedisZSetCommands.Tuple> tupleSetToTupleSet() {
        return TUPLE_SET_TO_TUPLE_SET;
    }

    public static Converter<Exception, DataAccessException> exceptionConverter() {
        return EXCEPTION_CONVERTER;
    }

    public static String[] toStrings(byte[][] source) {
        String[] result = new String[source.length];
        for (int i = 0; i < source.length; ++i) {
            result[i] = SafeEncoder.encode((byte[])source[i]);
        }
        return result;
    }

    public static Set<RedisZSetCommands.Tuple> toTupleSet(Set<Tuple> source) {
        return TUPLE_SET_TO_TUPLE_SET.convert(source);
    }

    public static byte[] toBytes(Integer source) {
        return String.valueOf(source).getBytes();
    }

    public static byte[] toBytes(Long source) {
        return String.valueOf(source).getBytes();
    }

    public static byte[] toBytes(Double source) {
        return JedisConverters.toBytes(String.valueOf(source));
    }

    public static byte[] toBytes(String source) {
        return (byte[])STRING_TO_BYTES.convert((Object)source);
    }

    public static String toString(byte[] source) {
        return source == null ? null : SafeEncoder.encode((byte[])source);
    }

    public static RedisClusterNode toNode(Object source) {
        return (RedisClusterNode)OBJECT_TO_CLUSTER_NODE_CONVERTER.convert(source);
    }

    public static List<RedisClientInfo> toListOfRedisClientInformation(String source) {
        if (!StringUtils.hasText((String)source)) {
            return Collections.emptyList();
        }
        return (List)STRING_TO_CLIENT_INFO_CONVERTER.convert((Object)source.split("\\r?\\n"));
    }

    public static List<RedisServer> toListOfRedisServer(List<Map<String, String>> source) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyList();
        }
        ArrayList<RedisServer> sentinels = new ArrayList<RedisServer>();
        for (Map<String, String> info : source) {
            sentinels.add(RedisServer.newServerFrom(Converters.toProperties(info)));
        }
        return sentinels;
    }

    public static DataAccessException toDataAccessException(Exception ex) {
        return (DataAccessException)((Object)EXCEPTION_CONVERTER.convert((Object)ex));
    }

    public static BinaryClient.LIST_POSITION toListPosition(RedisListCommands.Position source) {
        Assert.notNull((Object)"list positions are mandatory");
        return RedisListCommands.Position.AFTER.equals((Object)source) ? BinaryClient.LIST_POSITION.AFTER : BinaryClient.LIST_POSITION.BEFORE;
    }

    public static byte[][] toByteArrays(Map<byte[], byte[]> source) {
        byte[][] result = new byte[source.size() * 2][];
        int index = 0;
        for (Map.Entry<byte[], byte[]> entry : source.entrySet()) {
            result[index++] = entry.getKey();
            result[index++] = entry.getValue();
        }
        return result;
    }

    public static SortingParams toSortingParams(SortParameters params) {
        SortingParams jedisParams = null;
        if (params != null) {
            Boolean isAlpha;
            SortParameters.Order order;
            SortParameters.Range limit;
            byte[][] getPattern;
            jedisParams = new SortingParams();
            byte[] byPattern = params.getByPattern();
            if (byPattern != null) {
                jedisParams.by(params.getByPattern());
            }
            if ((getPattern = params.getGetPattern()) != null) {
                jedisParams.get(getPattern);
            }
            if ((limit = params.getLimit()) != null) {
                jedisParams.limit((int)limit.getStart(), (int)limit.getCount());
            }
            if ((order = params.getOrder()) != null && order.equals((Object)SortParameters.Order.DESC)) {
                jedisParams.desc();
            }
            if ((isAlpha = params.isAlphabetic()) != null && isAlpha.booleanValue()) {
                jedisParams.alpha();
            }
        }
        return jedisParams;
    }

    public static BitOP toBitOp(RedisStringCommands.BitOperation bitOp) {
        switch (bitOp) {
            case AND: {
                return BitOP.AND;
            }
            case OR: {
                return BitOP.OR;
            }
            case NOT: {
                return BitOP.NOT;
            }
            case XOR: {
                return BitOP.XOR;
            }
        }
        throw new IllegalArgumentException();
    }

    public static byte[] boundaryToBytesForZRange(RedisZSetCommands.Range.Boundary boundary, byte[] defaultValue) {
        if (boundary == null || boundary.getValue() == null) {
            return defaultValue;
        }
        return JedisConverters.boundaryToBytes(boundary, new byte[0], JedisConverters.toBytes("("));
    }

    public static byte[] boundaryToBytesForZRangeByLex(RedisZSetCommands.Range.Boundary boundary, byte[] defaultValue) {
        if (boundary == null || boundary.getValue() == null) {
            return defaultValue;
        }
        return JedisConverters.boundaryToBytes(boundary, JedisConverters.toBytes("["), JedisConverters.toBytes("("));
    }

    public static byte[] toSetCommandExPxArgument(Expiration expiration) {
        return (byte[])EXPIRATION_TO_COMMAND_OPTION_CONVERTER.convert((Object)expiration);
    }

    public static byte[] toSetCommandNxXxArgument(RedisStringCommands.SetOption option) {
        return (byte[])SET_OPTION_TO_COMMAND_OPTION_CONVERTER.convert((Object)option);
    }

    private static byte[] boundaryToBytes(RedisZSetCommands.Range.Boundary boundary, byte[] inclPrefix, byte[] exclPrefix) {
        byte[] prefix = boundary.isIncluding() ? inclPrefix : exclPrefix;
        byte[] value = null;
        if (boundary.getValue() instanceof byte[]) {
            value = (byte[])boundary.getValue();
        } else if (boundary.getValue() instanceof Double) {
            value = JedisConverters.toBytes((Double)boundary.getValue());
        } else if (boundary.getValue() instanceof Long) {
            value = JedisConverters.toBytes((Long)boundary.getValue());
        } else if (boundary.getValue() instanceof Integer) {
            value = JedisConverters.toBytes((Integer)boundary.getValue());
        } else if (boundary.getValue() instanceof String) {
            value = JedisConverters.toBytes((String)boundary.getValue());
        } else {
            throw new IllegalArgumentException(String.format("Cannot convert %s to binary format", boundary.getValue()));
        }
        ByteBuffer buffer = ByteBuffer.allocate(prefix.length + value.length);
        buffer.put(prefix);
        buffer.put(value);
        return buffer.array();
    }

    public static ScanParams toScanParams(ScanOptions options) {
        ScanParams sp = new ScanParams();
        if (!options.equals(ScanOptions.NONE)) {
            if (options.getCount() != null) {
                sp.count(options.getCount().intValue());
            }
            if (StringUtils.hasText((String)options.getPattern())) {
                sp.match(options.getPattern());
            }
        }
        return sp;
    }

    static Converter<List<String>, Long> toTimeConverter() {
        return STRING_LIST_TO_TIME_CONVERTER;
    }

    static {
        EXCEPTION_CONVERTER = new JedisExceptionConverter();
        STRING_TO_CLIENT_INFO_CONVERTER = new StringToRedisClientInfoConverter();
        STRING_TO_BYTES = new Converter<String, byte[]>(){

            public byte[] convert(String source) {
                return source == null ? null : SafeEncoder.encode((String)source);
            }
        };
        STRING_LIST_TO_BYTE_LIST = new ListConverter<String, byte[]>(STRING_TO_BYTES);
        STRING_SET_TO_BYTE_SET = new SetConverter<String, byte[]>(STRING_TO_BYTES);
        STRING_MAP_TO_BYTE_MAP = new MapConverter<String, byte[]>(STRING_TO_BYTES);
        TUPLE_CONVERTER = new Converter<Tuple, RedisZSetCommands.Tuple>(){

            public RedisZSetCommands.Tuple convert(Tuple source) {
                return source != null ? new DefaultTuple(source.getBinaryElement(), source.getScore()) : null;
            }
        };
        TUPLE_SET_TO_TUPLE_SET = new SetConverter<Tuple, RedisZSetCommands.Tuple>(TUPLE_CONVERTER);
        TUPLE_LIST_TO_TUPLE_LIST_CONVERTER = new ListConverter<Tuple, RedisZSetCommands.Tuple>(TUPLE_CONVERTER);
        PLUS_BYTES = JedisConverters.toBytes("+");
        MINUS_BYTES = JedisConverters.toBytes("-");
        POSITIVE_INFINITY_BYTES = JedisConverters.toBytes("+inf");
        NEGATIVE_INFINITY_BYTES = JedisConverters.toBytes("-inf");
        OBJECT_TO_CLUSTER_NODE_CONVERTER = new Converter<Object, RedisClusterNode>(){

            public RedisClusterNode convert(Object infos) {
                List values = (List)infos;
                RedisClusterNode.SlotRange range = new RedisClusterNode.SlotRange(((Number)values.get(0)).intValue(), ((Number)values.get(1)).intValue());
                List nodeInfo = (List)values.get(2);
                return new RedisClusterNode(JedisConverters.toString((byte[])nodeInfo.get(0)), ((Number)nodeInfo.get(1)).intValue(), range);
            }
        };
        EX = JedisConverters.toBytes("EX");
        PX = JedisConverters.toBytes("PX");
        EXPIRATION_TO_COMMAND_OPTION_CONVERTER = new Converter<Expiration, byte[]>(){

            public byte[] convert(Expiration source) {
                if (source == null || source.isPersistent()) {
                    return new byte[0];
                }
                if (ObjectUtils.nullSafeEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)source.getTimeUnit()))) {
                    return PX;
                }
                return EX;
            }
        };
        NX = JedisConverters.toBytes("NX");
        XX = JedisConverters.toBytes("XX");
        SET_OPTION_TO_COMMAND_OPTION_CONVERTER = new Converter<RedisStringCommands.SetOption, byte[]>(){

            public byte[] convert(RedisStringCommands.SetOption source) {
                switch (source) {
                    case UPSERT: {
                        return new byte[0];
                    }
                    case SET_IF_ABSENT: {
                        return NX;
                    }
                    case SET_IF_PRESENT: {
                        return XX;
                    }
                }
                throw new IllegalArgumentException(String.format("Invalid argument %s for SetOption.", new Object[]{source}));
            }
        };
        STRING_LIST_TO_TIME_CONVERTER = new Converter<List<String>, Long>(){

            public Long convert(List<String> source) {
                Assert.notEmpty(source, (String)"Received invalid result from server. Expected 2 items in collection.");
                Assert.isTrue((source.size() == 2 ? 1 : 0) != 0, (String)("Received invalid nr of arguments from redis server. Expected 2 received " + source.size()));
                return Converters.toTimeMillis(source.get(0), source.get(1));
            }
        };
    }
}

