/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd;

import db.sql.api.Cmd;
import db.sql.api.cmd.LikeMode;
import db.sql.api.cmd.basic.ICondition;
import db.sql.api.cmd.basic.IParamWrap;
import db.sql.api.cmd.executor.IQuery;
import db.sql.api.impl.cmd.basic.BasicValue;
import db.sql.api.impl.cmd.basic.Column;
import db.sql.api.impl.cmd.basic.Condition;
import db.sql.api.impl.cmd.basic.Count1;
import db.sql.api.impl.cmd.basic.CountAll;
import db.sql.api.impl.cmd.basic.DatePattern;
import db.sql.api.impl.cmd.condition.Between;
import db.sql.api.impl.cmd.condition.Empty;
import db.sql.api.impl.cmd.condition.Eq;
import db.sql.api.impl.cmd.condition.Exists;
import db.sql.api.impl.cmd.condition.Gt;
import db.sql.api.impl.cmd.condition.Gte;
import db.sql.api.impl.cmd.condition.In;
import db.sql.api.impl.cmd.condition.IsNotNull;
import db.sql.api.impl.cmd.condition.IsNull;
import db.sql.api.impl.cmd.condition.Like;
import db.sql.api.impl.cmd.condition.Lt;
import db.sql.api.impl.cmd.condition.Lte;
import db.sql.api.impl.cmd.condition.Ne;
import db.sql.api.impl.cmd.condition.NotBetween;
import db.sql.api.impl.cmd.condition.NotEmpty;
import db.sql.api.impl.cmd.condition.NotExists;
import db.sql.api.impl.cmd.condition.NotIn;
import db.sql.api.impl.cmd.condition.NotLike;
import db.sql.api.impl.cmd.dbFun.Abs;
import db.sql.api.impl.cmd.dbFun.Acos;
import db.sql.api.impl.cmd.dbFun.Asin;
import db.sql.api.impl.cmd.dbFun.Atan;
import db.sql.api.impl.cmd.dbFun.Avg;
import db.sql.api.impl.cmd.dbFun.Case;
import db.sql.api.impl.cmd.dbFun.Ceil;
import db.sql.api.impl.cmd.dbFun.CharLength;
import db.sql.api.impl.cmd.dbFun.Concat;
import db.sql.api.impl.cmd.dbFun.ConcatAs;
import db.sql.api.impl.cmd.dbFun.Cos;
import db.sql.api.impl.cmd.dbFun.Cot;
import db.sql.api.impl.cmd.dbFun.Count;
import db.sql.api.impl.cmd.dbFun.CurrentDate;
import db.sql.api.impl.cmd.dbFun.CurrentDateTime;
import db.sql.api.impl.cmd.dbFun.CurrentTime;
import db.sql.api.impl.cmd.dbFun.DateAdd;
import db.sql.api.impl.cmd.dbFun.DateDiff;
import db.sql.api.impl.cmd.dbFun.DateFormat;
import db.sql.api.impl.cmd.dbFun.Day;
import db.sql.api.impl.cmd.dbFun.Degrees;
import db.sql.api.impl.cmd.dbFun.Divide;
import db.sql.api.impl.cmd.dbFun.Exp;
import db.sql.api.impl.cmd.dbFun.Field;
import db.sql.api.impl.cmd.dbFun.FindInSet;
import db.sql.api.impl.cmd.dbFun.Floor;
import db.sql.api.impl.cmd.dbFun.Hour;
import db.sql.api.impl.cmd.dbFun.If;
import db.sql.api.impl.cmd.dbFun.IfNull;
import db.sql.api.impl.cmd.dbFun.InetAton;
import db.sql.api.impl.cmd.dbFun.InetNtoa;
import db.sql.api.impl.cmd.dbFun.Left;
import db.sql.api.impl.cmd.dbFun.Length;
import db.sql.api.impl.cmd.dbFun.Log;
import db.sql.api.impl.cmd.dbFun.Log10;
import db.sql.api.impl.cmd.dbFun.Log2;
import db.sql.api.impl.cmd.dbFun.Lower;
import db.sql.api.impl.cmd.dbFun.Lpad;
import db.sql.api.impl.cmd.dbFun.Ltrim;
import db.sql.api.impl.cmd.dbFun.Max;
import db.sql.api.impl.cmd.dbFun.Md5;
import db.sql.api.impl.cmd.dbFun.Min;
import db.sql.api.impl.cmd.dbFun.Mod;
import db.sql.api.impl.cmd.dbFun.Month;
import db.sql.api.impl.cmd.dbFun.Multiply;
import db.sql.api.impl.cmd.dbFun.Pi;
import db.sql.api.impl.cmd.dbFun.Plus;
import db.sql.api.impl.cmd.dbFun.Pow;
import db.sql.api.impl.cmd.dbFun.Radians;
import db.sql.api.impl.cmd.dbFun.Rand;
import db.sql.api.impl.cmd.dbFun.Repeat;
import db.sql.api.impl.cmd.dbFun.Replace;
import db.sql.api.impl.cmd.dbFun.Reverse;
import db.sql.api.impl.cmd.dbFun.Right;
import db.sql.api.impl.cmd.dbFun.Round;
import db.sql.api.impl.cmd.dbFun.Rpad;
import db.sql.api.impl.cmd.dbFun.Rtrim;
import db.sql.api.impl.cmd.dbFun.Sign;
import db.sql.api.impl.cmd.dbFun.Sin;
import db.sql.api.impl.cmd.dbFun.Sqrt;
import db.sql.api.impl.cmd.dbFun.Strcmp;
import db.sql.api.impl.cmd.dbFun.SubStr;
import db.sql.api.impl.cmd.dbFun.Subtract;
import db.sql.api.impl.cmd.dbFun.Sum;
import db.sql.api.impl.cmd.dbFun.Tan;
import db.sql.api.impl.cmd.dbFun.Trim;
import db.sql.api.impl.cmd.dbFun.Truncate;
import db.sql.api.impl.cmd.dbFun.Upper;
import db.sql.api.impl.cmd.dbFun.Weekday;
import db.sql.api.impl.cmd.dbFun.Year;
import db.sql.api.impl.tookit.SqlConst;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public final class Methods {
    public static Cmd paramWrapAndConvertToCmd(Cmd key, Object param) {
        if (Objects.isNull(param)) {
            return null;
        }
        if (param instanceof Cmd) {
            return (Cmd)param;
        }
        if (!(key instanceof IParamWrap)) {
            return new BasicValue(param);
        }
        IParamWrap paramWrap = (IParamWrap)key;
        return new BasicValue(paramWrap.paramWrap(param));
    }

    public static Object likeParamWrap(Cmd key, Object param, LikeMode mode, boolean isNotLike) {
        if (Objects.isNull(param)) {
            return null;
        }
        if (param instanceof Cmd) {
            return param;
        }
        if (!(key instanceof IParamWrap)) {
            return param;
        }
        IParamWrap paramWrap = (IParamWrap)key;
        return paramWrap.likeParamWrap(mode, param, isNotLike);
    }

    public static Column column(String column) {
        db.sql.api.impl.tookit.Objects.requireNonNull(column);
        return new Column(column);
    }

    public static Cmd cmd(Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        if (value instanceof Cmd) {
            return (Cmd)value;
        }
        return new BasicValue(value);
    }

    public static BasicValue value(Serializable value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new BasicValue(value);
    }

    public static Plus plus(Cmd key, Number value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Plus(key, value);
    }

    public static Plus plus(Cmd key, Cmd value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Plus(key, value);
    }

    public static Subtract subtract(Cmd key, Number value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Subtract(key, value);
    }

    public static Subtract subtract(Cmd key, Cmd value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Subtract(key, value);
    }

    public static Multiply multiply(Cmd key, Number value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Multiply(key, value);
    }

    public static Divide divide(Cmd key, Cmd value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Divide(key, value);
    }

    public static Divide divide(Cmd key, Number value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Divide(key, value);
    }

    public static Multiply multiply(Cmd key, Cmd value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Multiply(key, value);
    }

    public static Count count(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Count(key);
    }

    public static Count1 count1() {
        return Count1.INSTANCE;
    }

    public static CountAll countAll() {
        return CountAll.INSTANCE;
    }

    public static Count count(Cmd key, boolean distinct) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Count(key, distinct);
    }

    public static Sum sum(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Sum(key);
    }

    public static Min min(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Min(key);
    }

    public static Max max(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Max(key);
    }

    public static Avg avg(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Avg(key);
    }

    public static Abs abs(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Abs(key);
    }

    public static Pow pow(Cmd key, int n) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Pow(key, n);
    }

    public static Round round(Cmd key) {
        return Methods.round(key, 0);
    }

    public static Round round(Cmd key, int precision) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Round(key, precision);
    }

    public static Ceil ceil(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Ceil(key);
    }

    public static Floor floor(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Floor(key);
    }

    public static Rand rand(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Rand(key);
    }

    public static Rand rand(Cmd key, Number max) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(max);
        return new Rand(key, max);
    }

    public static Sign sign(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Sign(key);
    }

    public static Pi pi() {
        return new Pi();
    }

    public static Truncate truncate(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return Methods.truncate(key, 0);
    }

    public static Truncate truncate(Cmd key, int precision) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Truncate(key, precision);
    }

    public static Sqrt sqrt(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Sqrt(key);
    }

    public static Mod mod(Cmd key, Number number) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(number);
        return new Mod(key, number);
    }

    public static Exp exp(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Exp(key);
    }

    public static Log log(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Log(key);
    }

    public static Log2 log2(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Log2(key);
    }

    public static Log10 log10(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Log10(key);
    }

    public static Degrees degrees(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Degrees(key);
    }

    public static Radians radians(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Radians(key);
    }

    public static Sin sin(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Sin(key);
    }

    public static Asin asin(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Asin(key);
    }

    public static Cos cos(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Cos(key);
    }

    public static Acos acos(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Acos(key);
    }

    public static Tan tan(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Tan(key);
    }

    public static Atan atan(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Atan(key);
    }

    public static Cot cot(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Cot(key);
    }

    public static CharLength charLength(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new CharLength(key);
    }

    public static Length length(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Length(key);
    }

    public static Upper upper(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Upper(key);
    }

    public static Lower lower(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Lower(key);
    }

    public static Left left(Cmd key, int length) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Left(key, length);
    }

    public static Right right(Cmd key, int start) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Right(key, start);
    }

    public static SubStr subStr(Cmd key, int start) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new SubStr(key, start);
    }

    public static SubStr subStr(Cmd key, int start, int length) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new SubStr(key, start, length);
    }

    public static Lpad lpad(Cmd key, int length, String pad) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(pad);
        return new Lpad(key, length, pad);
    }

    public static Rpad rpad(Cmd key, int length, String pad) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(pad);
        return new Rpad(key, length, pad);
    }

    public static Trim trim(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Trim(key);
    }

    public static Ltrim ltrim(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Ltrim(key);
    }

    public static Rtrim rtrim(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Rtrim(key);
    }

    public static Strcmp strcmp(Cmd key, String str) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(str);
        return new Strcmp(key, str);
    }

    public static Repeat repeat(Cmd key, int n) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Repeat(key, n);
    }

    public static Replace replace(Cmd key, String target, String replacement) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(target);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(replacement);
        return new Replace(key, target, replacement);
    }

    public static Reverse reverse(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Reverse(key);
    }

    public static FindInSet findInSet(Cmd key, String match) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(match);
        return new FindInSet(key, match);
    }

    @SafeVarargs
    public static Field filed(Cmd key, Object ... values) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(values);
        return new Field(key, values);
    }

    public static CurrentDate currentDate() {
        return new CurrentDate();
    }

    public static CurrentTime currentTime() {
        return new CurrentTime();
    }

    public static CurrentDateTime currentDateTime() {
        return new CurrentDateTime();
    }

    public static Year year(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Year(key);
    }

    public static Month month(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Month(key);
    }

    public static DateFormat date(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new DateFormat(key, DatePattern.YYYY_MM_DD);
    }

    public static DateFormat dateFormat(Cmd key, String pattern) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(pattern);
        return new DateFormat(key, pattern);
    }

    public static DateFormat dateFormat(Cmd key, DatePattern pattern) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(pattern);
        return new DateFormat(key, pattern);
    }

    public static Day day(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Day(key);
    }

    public static Weekday weekday(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Weekday(key);
    }

    public static Hour hour(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Hour(key);
    }

    public static DateDiff dateDiff(Cmd key, Cmd another) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(another);
        return new DateDiff(key, another);
    }

    public static DateAdd dateAdd(Cmd key, int n, TimeUnit timeUnit) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new DateAdd(key, n, timeUnit);
    }

    public static Md5 md5(String str) {
        db.sql.api.impl.tookit.Objects.requireNonEmpty(str);
        return new Md5(str);
    }

    public static Md5 md5(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Md5(key);
    }

    public static InetAton inetAton(String ip) {
        db.sql.api.impl.tookit.Objects.requireNonEmpty(ip);
        return new InetAton(ip);
    }

    public static InetAton inetAton(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new InetAton(key);
    }

    public static InetNtoa inetNtoa(Number ipNumber) {
        db.sql.api.impl.tookit.Objects.requireNonNull(ipNumber);
        return new InetNtoa(ipNumber);
    }

    public static InetNtoa inetNtoa(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new InetNtoa(key);
    }

    @SafeVarargs
    public static Concat concat(Cmd key, Object ... values) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(values);
        return new Concat(key, values);
    }

    @SafeVarargs
    public static ConcatAs concatAs(Cmd key, String split, Object ... values) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(split);
        db.sql.api.impl.tookit.Objects.requireNonNull(values);
        return new ConcatAs(key, split, values);
    }

    public static If if_(Condition condition, Serializable value, Serializable thenValue) {
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        db.sql.api.impl.tookit.Objects.requireNonNull(thenValue);
        db.sql.api.impl.tookit.Objects.requireNonNull(condition);
        return new If((ICondition)condition, value, thenValue);
    }

    public static If if_(Condition condition, Cmd value, Serializable thenValue) {
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        db.sql.api.impl.tookit.Objects.requireNonNull(thenValue);
        db.sql.api.impl.tookit.Objects.requireNonNull(condition);
        return new If((ICondition)condition, value, thenValue);
    }

    public static If if_(Condition condition, Serializable value, Cmd thenValue) {
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        db.sql.api.impl.tookit.Objects.requireNonNull(thenValue);
        db.sql.api.impl.tookit.Objects.requireNonNull(condition);
        return new If((ICondition)condition, value, thenValue);
    }

    public static If if_(Condition condition, Cmd value, Cmd thenValue) {
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        db.sql.api.impl.tookit.Objects.requireNonNull(thenValue);
        db.sql.api.impl.tookit.Objects.requireNonNull(condition);
        return new If((ICondition)condition, value, thenValue);
    }

    public static IfNull ifNull(Cmd key, Cmd value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new IfNull(key, value);
    }

    public static IfNull ifNull(Cmd key, Serializable value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new IfNull(key, value);
    }

    public static IsNull isNull(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new IsNull(key);
    }

    public static IsNotNull isNotNull(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new IsNotNull(key);
    }

    public static Eq isEmpty(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Eq(key, (Serializable)SqlConst.EMPTY);
    }

    public static Ne isNotEmpty(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Ne(key, (Serializable)SqlConst.EMPTY);
    }

    public static Case case_() {
        return new Case();
    }

    public static Eq eq(Cmd key, Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Eq(key, Methods.paramWrapAndConvertToCmd(key, value));
    }

    public static Ne ne(Cmd key, Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Ne(key, Methods.paramWrapAndConvertToCmd(key, value));
    }

    public static NotEmpty notEmpty(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new NotEmpty(key);
    }

    public static Empty empty(Cmd key) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        return new Empty(key);
    }

    public static Gt gt(Cmd key, Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Gt(key, Methods.paramWrapAndConvertToCmd(key, value));
    }

    public static Gte gte(Cmd key, Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Gte(key, Methods.paramWrapAndConvertToCmd(key, value));
    }

    public static Lt lt(Cmd key, Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Lt(key, Methods.paramWrapAndConvertToCmd(key, value));
    }

    public static Lte lte(Cmd key, Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        return new Lte(key, Methods.paramWrapAndConvertToCmd(key, value));
    }

    @SafeVarargs
    public static In in(Cmd key, Object ... values) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(values);
        Cmd[] cmds = new Cmd[values.length];
        for (int i = 0; i < values.length; ++i) {
            cmds[i] = Methods.paramWrapAndConvertToCmd(key, values[i]);
        }
        return new In(key).add(cmds);
    }

    public static In in(Cmd key, Collection<?> values) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(values);
        return new In(key).add(values.stream().map(item -> Methods.paramWrapAndConvertToCmd(key, item)).collect(Collectors.toList()));
    }

    public static In in(Cmd key, IQuery query) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(query);
        return new In(key).add((Cmd)query);
    }

    @SafeVarargs
    public static NotIn notIn(Cmd key, Object ... values) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(values);
        Cmd[] cmds = new Cmd[values.length];
        for (int i = 0; i < values.length; ++i) {
            cmds[i] = Methods.paramWrapAndConvertToCmd(key, values[i]);
        }
        return new NotIn(key).add(cmds);
    }

    public static NotIn notIn(Cmd key, Collection<?> values) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonEmpty(values);
        return new NotIn(key).add(values.stream().map(item -> Methods.paramWrapAndConvertToCmd(key, item)).collect(Collectors.toList()));
    }

    public static NotIn notIn(Cmd key, IQuery query) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(query);
        return new NotIn(key).add((Cmd)query);
    }

    public static Exists exists(IQuery query) {
        db.sql.api.impl.tookit.Objects.requireNonNull(query);
        return new Exists((Cmd)query);
    }

    public static NotExists notExists(IQuery query) {
        db.sql.api.impl.tookit.Objects.requireNonNull(query);
        return new NotExists((Cmd)query);
    }

    public static Between between(Cmd key, Serializable value, Serializable value2) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        db.sql.api.impl.tookit.Objects.requireNonNull(value2);
        return new Between(key, Methods.paramWrapAndConvertToCmd(key, value), Methods.paramWrapAndConvertToCmd(key, value2));
    }

    public static NotBetween notBetween(Cmd key, Serializable value, Serializable value2) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        db.sql.api.impl.tookit.Objects.requireNonNull(value);
        db.sql.api.impl.tookit.Objects.requireNonNull(value2);
        return new NotBetween(key, Methods.paramWrapAndConvertToCmd(key, value), Methods.paramWrapAndConvertToCmd(key, value2));
    }

    public static Like like(Cmd key, Object value) {
        return Methods.like(LikeMode.DEFAULT, key, value);
    }

    public static Like like(LikeMode mode, Cmd key, Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        Object wrapValue = Methods.likeParamWrap(key, value, mode, false);
        if (wrapValue instanceof Object[]) {
            Object[] values = (Object[])wrapValue;
            mode = (LikeMode)values[0];
            value = values[1];
        }
        return new Like(mode, key, value);
    }

    public static NotLike notLike(Cmd key, Object value) {
        return Methods.notLike(LikeMode.DEFAULT, key, value);
    }

    public static NotLike notLike(LikeMode mode, Cmd key, Object value) {
        db.sql.api.impl.tookit.Objects.requireNonNull(key);
        Object wrapValue = Methods.likeParamWrap(key, value, mode, true);
        if (wrapValue instanceof Object[]) {
            Object[] values = (Object[])wrapValue;
            mode = (LikeMode)values[0];
            value = values[1];
        }
        return new NotLike(mode, key, value);
    }
}

