/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.basic;

import db.sql.api.Cmd;
import db.sql.api.DbType;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.basic.IDataset;
import db.sql.api.cmd.basic.IDatasetField;
import db.sql.api.impl.cmd.basic.AbstractField;
import db.sql.api.impl.cmd.basic.Table;
import db.sql.api.impl.cmd.struct.insert.InsertFields;
import db.sql.api.impl.cmd.struct.query.Select;
import db.sql.api.impl.tookit.SqlConst;
import db.sql.api.tookit.CmdUtils;

public abstract class AbstractDatasetField<T extends AbstractDatasetField<T>>
extends AbstractField<T>
implements IDatasetField<T> {
    private final IDataset table;
    private final String name;

    public AbstractDatasetField(IDataset table, String name) {
        this.table = table;
        this.name = name;
    }

    public IDataset getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public String getName(DbType dbType) {
        return dbType.wrap(this.name);
    }

    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        if (parent instanceof InsertFields) {
            sqlBuilder.append(this.getName(context.getDbType()));
            return sqlBuilder;
        }
        if (this.table.getAlias() != null) {
            sqlBuilder.append(SqlConst.BLANK).append(this.table.getAlias()).append(SqlConst.DOT);
        } else {
            sqlBuilder.append(SqlConst.BLANK);
        }
        sqlBuilder.append(this.getName(context.getDbType()));
        if (parent instanceof Select) {
            if (this.getAlias() != null && !"".equals(this.getAlias())) {
                if (this.getAlias().equals(this.getName())) {
                    return sqlBuilder;
                }
                sqlBuilder.append(SqlConst.AS(context.getDbType()));
                return sqlBuilder.append(this.getAlias());
            }
            if (!(this.getTable() instanceof Table)) {
                return sqlBuilder;
            }
            String prefix = ((Table)this.getTable()).getPrefix();
            if (prefix == null || "".equals(prefix)) {
                return sqlBuilder;
            }
            sqlBuilder.append(SqlConst.AS(context.getDbType()));
            sqlBuilder.append(prefix);
            sqlBuilder.append(this.getName());
            return sqlBuilder;
        }
        return sqlBuilder;
    }

    public boolean contain(Cmd cmd) {
        return CmdUtils.contain((Cmd)cmd, (Cmd)this.table);
    }
}

