/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.basic;

import db.sql.api.Cmd;
import db.sql.api.SqlBuilderContext;
import db.sql.api.impl.cmd.basic.AbstractAlias;
import db.sql.api.impl.cmd.basic.BasicValue;
import db.sql.api.impl.cmd.struct.query.Select;
import db.sql.api.impl.tookit.SqlConst;
import db.sql.api.tookit.CmdUtils;
import java.text.MessageFormat;
import java.util.Objects;

public abstract class BaseTemplate<T extends BaseTemplate<T>>
extends AbstractAlias<T>
implements Cmd {
    protected final String template;
    protected final Cmd[] params;

    @SafeVarargs
    public BaseTemplate(String template, Object ... params) {
        this.template = template;
        if (Objects.nonNull(params)) {
            Cmd[] cmds = new Cmd[params.length];
            for (int i = 0; i < params.length; ++i) {
                Object param = params[i];
                cmds[i] = param instanceof Cmd ? (Cmd)param : new BasicValue(param);
            }
            this.params = cmds;
        } else {
            this.params = null;
        }
    }

    @SafeVarargs
    public BaseTemplate(String template, Cmd ... params) {
        this.template = template;
        this.params = params;
    }

    private void appendAlias(Cmd module, Cmd user, SqlBuilderContext context, StringBuilder sqlBuilder) {
        if (module instanceof Select && user instanceof Select && this.getAlias() != null) {
            sqlBuilder.append(SqlConst.AS(context.getDbType()));
            sqlBuilder.append(this.getAlias());
        }
    }

    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        sqlBuilder.append(SqlConst.BLANK);
        String str = this.template;
        if (Objects.nonNull(this.params) && this.params.length > 0) {
            Object[] paramsStr = new Object[this.params.length];
            for (int i = 0; i < this.params.length; ++i) {
                paramsStr[i] = this.params[i].sql(module, (Cmd)this, context, new StringBuilder());
            }
            str = MessageFormat.format(this.template, paramsStr);
        }
        sqlBuilder.append(SqlConst.BLANK).append(str);
        this.appendAlias(module, parent, context, sqlBuilder);
        return sqlBuilder;
    }

    public final boolean contain(Cmd cmd) {
        if (Objects.isNull(this.params)) {
            return false;
        }
        return CmdUtils.contain((Cmd)cmd, (Object[])this.params);
    }
}

