/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.basic;

import db.sql.api.Cmd;
import db.sql.api.DbType;
import db.sql.api.SqlBuilderContext;
import db.sql.api.impl.cmd.Methods;

public interface DatePattern
extends Cmd {
    public static final DatePattern YYYY_MM_DD = new DatePattern(){

        @Override
        public String pattern(DbType dbType) {
            return String.format("%s-%s-%s", this.yearPattern(dbType), this.monthPattern(dbType), this.dayPattern(dbType));
        }
    };
    public static final DatePattern YYYY_MM_DD_HH_MM_SS = new DatePattern(){

        @Override
        public String pattern(DbType dbType) {
            return String.format("%s-%s-%s %s:%s:%s", this.yearPattern(dbType), this.monthPattern(dbType), this.dayPattern(dbType), this.hourPattern(dbType), this.minutePattern(dbType), this.secondPattern(dbType));
        }
    };

    default public String yearPattern(DbType dbType) {
        switch (dbType) {
            case KING_BASE: 
            case H2: 
            case PGSQL: 
            case ORACLE: 
            case DB2: {
                return "YYYY";
            }
            case DM: 
            case MARIA_DB: 
            case MYSQL: {
                return "%Y";
            }
            case SQL_SERVER: {
                return "yyyy";
            }
        }
        throw new RuntimeException("Not supported");
    }

    default public String monthPattern(DbType dbType) {
        switch (dbType) {
            case KING_BASE: 
            case H2: 
            case PGSQL: 
            case ORACLE: 
            case DB2: 
            case SQL_SERVER: {
                return "MM";
            }
            case DM: 
            case MARIA_DB: 
            case MYSQL: {
                return "%m";
            }
        }
        throw new RuntimeException("Not supported");
    }

    default public String dayPattern(DbType dbType) {
        switch (dbType) {
            case KING_BASE: 
            case H2: 
            case PGSQL: 
            case ORACLE: 
            case DB2: {
                return "DD";
            }
            case DM: 
            case MARIA_DB: 
            case MYSQL: {
                return "%d";
            }
            case SQL_SERVER: {
                return "dd";
            }
        }
        throw new RuntimeException("Not supported");
    }

    default public String hourPattern(DbType dbType) {
        switch (dbType) {
            case KING_BASE: 
            case H2: 
            case PGSQL: 
            case ORACLE: 
            case DB2: {
                return "HH24";
            }
            case DM: 
            case MARIA_DB: 
            case MYSQL: {
                return "%H";
            }
            case SQL_SERVER: {
                return "HH";
            }
        }
        throw new RuntimeException("Not supported");
    }

    default public String minutePattern(DbType dbType) {
        switch (dbType) {
            case KING_BASE: 
            case H2: 
            case PGSQL: 
            case ORACLE: 
            case DB2: {
                return "MI";
            }
            case DM: 
            case MARIA_DB: 
            case MYSQL: {
                return "%i";
            }
            case SQL_SERVER: {
                return "mm";
            }
        }
        throw new RuntimeException("Not supported");
    }

    default public String secondPattern(DbType dbType) {
        switch (dbType) {
            case KING_BASE: 
            case H2: 
            case PGSQL: 
            case ORACLE: 
            case DB2: {
                return "SS";
            }
            case DM: 
            case MARIA_DB: 
            case MYSQL: {
                return "%s";
            }
            case SQL_SERVER: {
                return "ss";
            }
        }
        throw new RuntimeException("Not supported");
    }

    public String pattern(DbType var1);

    default public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        Cmd pattern = Methods.cmd(this.pattern(context.getDbType()));
        pattern.sql(module, parent, context, sqlBuilder);
        return sqlBuilder;
    }

    default public boolean contain(Cmd cmd) {
        return false;
    }
}

