/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.basic;

import db.sql.api.Cmd;
import db.sql.api.DbType;
import db.sql.api.Getter;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.basic.IDataset;
import db.sql.api.cmd.basic.ITable;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.struct.From;
import db.sql.api.impl.cmd.struct.Join;
import db.sql.api.impl.tookit.LambdaUtil;
import db.sql.api.impl.tookit.SqlConst;
import java.util.Objects;

public class Table
implements ITable<Table, TableField>,
IDataset<Table, TableField> {
    protected String alias;
    protected String prefix;
    private String name;
    private String forceIndex;

    public Table(String name) {
        this.name = name;
    }

    public Table(String name, String alias) {
        this(name);
        this.alias = alias;
    }

    public TableField $(String name) {
        return new TableField(this, name);
    }

    public String getName() {
        return this.name;
    }

    public Table setName(String name) {
        this.name = name;
        return this;
    }

    public String getName(DbType dbType) {
        return dbType.wrap(this.name);
    }

    public String getAlias() {
        return this.alias;
    }

    public Table setAlias(String alias) {
        return this.as(alias);
    }

    public Table as(String alias) {
        this.alias = alias;
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Table setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public StringBuilder sql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        sqlBuilder.append(this.getName(context.getDbType()));
        if (this.getAlias() != null) {
            sqlBuilder.append(SqlConst.BLANK).append(this.getAlias());
        }
        if ((parent instanceof From || parent instanceof Join) && Objects.nonNull(this.forceIndex) && !"".equals(this.forceIndex)) {
            sqlBuilder.append(SqlConst.FORCE_INDEX(context.getDbType(), this.forceIndex));
        }
        return sqlBuilder;
    }

    public boolean contain(Cmd cmd) {
        return false;
    }

    public Table forceIndex(String forceIndex) {
        this.forceIndex = forceIndex;
        return this;
    }

    public <E> TableField $(Getter<E> column) {
        return this.$(LambdaUtil.getName(column));
    }
}

