/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.dbFun;

import db.sql.api.Cmd;
import db.sql.api.DbType;
import db.sql.api.SqlBuilderContext;
import db.sql.api.impl.cmd.Methods;
import db.sql.api.impl.cmd.basic.BasicValue;
import db.sql.api.impl.cmd.basic.Condition;
import db.sql.api.impl.cmd.dbFun.BasicFunction;
import db.sql.api.impl.cmd.dbFun.CaseWhen;
import db.sql.api.impl.tookit.SqlConst;
import db.sql.api.tookit.CmdUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class Case
extends BasicFunction<Case> {
    private final List<Cmd> values = new ArrayList<Cmd>();

    public Case() {
        super(SqlConst.CASE, null);
    }

    public Case when(Condition condition, Cmd then) {
        this.values.add(new CaseWhen(condition, then));
        return this;
    }

    public Case when(Condition condition, Serializable then) {
        return this.when(condition, Methods.cmd(then));
    }

    public Case when(boolean when, Condition condition, Serializable then) {
        if (!when) {
            return this;
        }
        return this.when(condition, then);
    }

    public <V extends Serializable> Case when(Condition condition, V then, Predicate<V> predicate) {
        return this.when(predicate.test(then), condition, then);
    }

    public Case else_(Cmd then) {
        this.values.add(then);
        return this;
    }

    public Case else_(Serializable then) {
        return this.else_(Methods.cmd(then));
    }

    @Override
    public StringBuilder functionSql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        sqlBuilder.append(SqlConst.BRACKET_LEFT).append(this.operator);
        for (Cmd item : this.values) {
            if (!(item instanceof CaseWhen)) {
                sqlBuilder.append(SqlConst.ELSE);
                if (context.getDbType() == DbType.DB2 && item instanceof BasicValue) {
                    BasicValue basicValue = (BasicValue)item;
                    if (basicValue.getValue() instanceof Number) {
                        sqlBuilder.append(basicValue.getValue());
                        continue;
                    }
                    sqlBuilder.append("'").append(basicValue.getValue()).append("'");
                    continue;
                }
            }
            item.sql(module, (Cmd)this, context, sqlBuilder);
        }
        sqlBuilder.append(SqlConst.END);
        sqlBuilder.append(SqlConst.BRACKET_RIGHT);
        return sqlBuilder;
    }

    @Override
    public boolean contain(Cmd cmd) {
        return CmdUtils.contain((Cmd)cmd, this.values);
    }
}

