/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.dbFun;

import db.sql.api.Cmd;
import db.sql.api.DbType;
import db.sql.api.SqlBuilderContext;
import db.sql.api.impl.cmd.Methods;
import db.sql.api.impl.cmd.basic.BasicValue;
import db.sql.api.impl.cmd.dbFun.BasicFunction;
import db.sql.api.impl.tookit.SqlConst;
import db.sql.api.tookit.CmdUtils;

public class ConcatAs
extends BasicFunction<ConcatAs> {
    private final Cmd[] values;
    private final Cmd split;

    public ConcatAs(Cmd key, String split, Object ... values) {
        super(SqlConst.CONCAT_WS, key);
        this.split = Methods.cmd(split);
        Cmd[] vs = new Cmd[values.length];
        int i = 0;
        for (Object value : values) {
            if (value == null) continue;
            vs[i++] = value instanceof Cmd ? (Cmd)value : Methods.cmd(value);
        }
        this.values = vs;
    }

    private static StringBuilder join(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder builder, Cmd[] cmds, char[] delimiter) {
        if (cmds == null || cmds.length < 1) {
            return builder;
        }
        int length = cmds.length;
        for (int i = 0; i < length; ++i) {
            if (i != 0 && delimiter != null) {
                builder.append(delimiter);
            }
            Cmd value = cmds[i];
            builder = cmds[i].sql(module, parent, context, builder);
            if (value.getClass() != BasicValue.class || context.getDbType() != DbType.PGSQL) continue;
            builder.append(SqlConst.CAST_TEXT);
        }
        return builder;
    }

    @Override
    public StringBuilder functionSql(Cmd module, Cmd parent, SqlBuilderContext context, StringBuilder sqlBuilder) {
        if (this.values == null || this.values.length < 1) {
            return sqlBuilder;
        }
        if (context.getDbType() == DbType.ORACLE || context.getDbType() == DbType.DB2) {
            sqlBuilder.append(SqlConst.BRACKET_LEFT);
            this.key.sql(module, parent, context, sqlBuilder);
            for (Cmd value : this.values) {
                sqlBuilder.append(SqlConst.CONCAT_SPLIT_SYMBOL);
                this.split.sql(module, parent, context, sqlBuilder);
                sqlBuilder.append(SqlConst.CONCAT_SPLIT_SYMBOL);
                value.sql(module, parent, context, sqlBuilder);
            }
            sqlBuilder.append(SqlConst.BRACKET_RIGHT);
            return sqlBuilder;
        }
        sqlBuilder.append(this.operator).append(SqlConst.BRACKET_LEFT);
        this.split.sql(module, (Cmd)this, context, sqlBuilder);
        sqlBuilder.append(SqlConst.DELIMITER);
        this.key.sql(module, (Cmd)this, context, sqlBuilder);
        sqlBuilder.append(SqlConst.DELIMITER);
        ConcatAs.join(module, this, context, sqlBuilder, this.values, SqlConst.DELIMITER);
        sqlBuilder.append(SqlConst.BRACKET_RIGHT);
        return sqlBuilder;
    }

    @Override
    public boolean contain(Cmd cmd) {
        return CmdUtils.contain((Cmd)cmd, (Object[])new Object[]{this.key, this.values});
    }
}

