/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.executor;

import db.sql.api.Cmd;
import db.sql.api.Getter;
import db.sql.api.cmd.JoinMode;
import db.sql.api.cmd.basic.ICondition;
import db.sql.api.cmd.basic.IDataset;
import db.sql.api.cmd.basic.IDatasetField;
import db.sql.api.cmd.basic.ITable;
import db.sql.api.cmd.executor.IDelete;
import db.sql.api.cmd.struct.IJoin;
import db.sql.api.cmd.struct.Joins;
import db.sql.api.impl.cmd.CmdFactory;
import db.sql.api.impl.cmd.ConditionFactory;
import db.sql.api.impl.cmd.basic.Table;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.executor.BaseExecutor;
import db.sql.api.impl.cmd.struct.ConditionChain;
import db.sql.api.impl.cmd.struct.From;
import db.sql.api.impl.cmd.struct.Join;
import db.sql.api.impl.cmd.struct.On;
import db.sql.api.impl.cmd.struct.Where;
import db.sql.api.impl.cmd.struct.delete.DeleteTable;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractDelete<SELF extends AbstractDelete<SELF, CMD_FACTORY>, CMD_FACTORY extends CmdFactory>
extends BaseExecutor<SELF, CMD_FACTORY>
implements IDelete<SELF, Table, TableField, Cmd, Object, ConditionChain, DeleteTable, From, Join, On, Where> {
    protected final ConditionFactory conditionFactory;
    protected final CMD_FACTORY $;
    protected DeleteTable deleteTable;
    protected From from;
    protected Where where;
    protected Joins joins;

    public AbstractDelete(CMD_FACTORY $) {
        this.$ = $;
        this.conditionFactory = new ConditionFactory((CmdFactory)$);
    }

    public AbstractDelete(Where where) {
        this.$ = where.getConditionFactory().getCmdFactory();
        this.conditionFactory = where.getConditionFactory();
        this.where = where;
        this.append((Cmd)where);
    }

    public <T> TableField $(Getter<T> getter) {
        return this.$(getter, 1);
    }

    public <T> TableField $(Getter<T> getter, int storey) {
        return ((CmdFactory)this.$()).field((Getter)getter, storey);
    }

    public Table $(Class entityType) {
        return this.$(entityType, 1);
    }

    public Table $(Class entityType, int storey) {
        return ((CmdFactory)this.$()).table(entityType, storey);
    }

    public TableField $(Class entityType, String fieldName) {
        return this.$(entityType, fieldName, 1);
    }

    public TableField $(Class entityType, String fieldName, int storey) {
        return ((CmdFactory)this.$()).field(entityType, fieldName, storey);
    }

    @Override
    public CMD_FACTORY $() {
        return this.$;
    }

    @Override
    protected void initCmdSorts(Map<Class<? extends Cmd>, Integer> cmdSorts) {
        int i = 0;
        cmdSorts.put(DeleteTable.class, i += 10);
        cmdSorts.put(From.class, i += 10);
        cmdSorts.put(Joins.class, i += 10);
        cmdSorts.put(Where.class, i += 10);
    }

    public DeleteTable $delete(IDataset ... tables) {
        if (this.deleteTable == null) {
            this.deleteTable = new DeleteTable(tables);
        }
        this.append((Cmd)this.deleteTable);
        return this.deleteTable;
    }

    public SELF delete(Class ... entities) {
        int length = entities.length;
        IDataset[] tables = new Table[length];
        for (int i = 0; i < length; ++i) {
            Class entity = entities[i];
            tables[i] = ((CmdFactory)this.$).table(entity, 1);
        }
        return (SELF)((AbstractDelete)this.delete(tables));
    }

    public From $from(IDataset ... tables) {
        if (this.from == null) {
            this.from = new From();
            this.append((Cmd)this.from);
        }
        this.from.append(tables);
        return this.from;
    }

    public SELF from(Class entity, int storey, Consumer<Table> consumer) {
        this.fromEntityIntercept(entity, storey);
        ITable table = ((CmdFactory)this.$).table(entity, storey);
        this.from(new IDataset[]{table});
        if (Objects.nonNull(consumer)) {
            consumer.accept((Table)table);
        }
        return (SELF)this;
    }

    public Join $join(JoinMode mode, IDataset mainTable, IDataset secondTable) {
        Join join = new Join(mode, mainTable, secondTable, joinTable -> new On(this.conditionFactory, (Join)joinTable));
        if (Objects.isNull(this.joins)) {
            this.joins = new Joins();
            this.append((Cmd)this.joins);
        }
        this.joins.add((IJoin)join);
        return join;
    }

    public SELF join(JoinMode mode, Class mainTable, int mainTableStorey, Class secondTable, int secondTableStorey, Consumer<On> consumer) {
        consumer = this.joinEntityIntercept(mainTable, mainTableStorey, secondTable, secondTableStorey, consumer);
        return this.join(mode, ((CmdFactory)this.$).table(mainTable, mainTableStorey), ((CmdFactory)this.$).table(secondTable, secondTableStorey), (Consumer<On>)consumer);
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF join(JoinMode mode, Class mainTable, int mainTableStorey, DATASET secondTable, Consumer<On> consumer) {
        return this.join(mode, ((CmdFactory)this.$).table(mainTable, mainTableStorey), secondTable, consumer);
    }

    public Where $where() {
        if (this.where == null) {
            this.where = new Where(this.conditionFactory);
            this.append((Cmd)this.where);
        }
        return this.where;
    }

    public <T> SELF and(Getter<T> column, int storey, Function<TableField, ICondition> f) {
        this.$where().and(column, storey, f);
        return (SELF)this;
    }

    public <T> SELF or(Getter<T> column, int storey, Function<TableField, ICondition> f) {
        this.$where().or(column, storey, f);
        return (SELF)this;
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>, DATASET2 extends IDataset<DATASET2, DATASET_FIELD2>, DATASET_FIELD2 extends IDatasetField<DATASET_FIELD2>> SELF join(JoinMode mode, DATASET mainTable, DATASET2 secondTable, Consumer<On> consumer) {
        Join join = this.$join(mode, mainTable, secondTable);
        consumer.accept(join.getOn());
        return (SELF)this;
    }

    public DeleteTable getDeleteTable() {
        return this.deleteTable;
    }

    public From getFrom() {
        return this.from;
    }

    public Joins getJoins() {
        return this.joins;
    }

    public Where getWhere() {
        return this.where;
    }
}

