/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.executor;

import db.sql.api.Cmd;
import db.sql.api.Getter;
import db.sql.api.cmd.ColumnField;
import db.sql.api.cmd.GetterField;
import db.sql.api.cmd.IColumnField;
import db.sql.api.cmd.JoinMode;
import db.sql.api.cmd.basic.ICondition;
import db.sql.api.cmd.basic.IDataset;
import db.sql.api.cmd.basic.IDatasetField;
import db.sql.api.cmd.basic.IOrderByDirection;
import db.sql.api.cmd.basic.ITable;
import db.sql.api.cmd.basic.UnionsCmdLists;
import db.sql.api.cmd.executor.IQuery;
import db.sql.api.cmd.executor.IWithQuery;
import db.sql.api.cmd.struct.IJoin;
import db.sql.api.cmd.struct.Joins;
import db.sql.api.cmd.struct.query.IUnion;
import db.sql.api.cmd.struct.query.IWith;
import db.sql.api.cmd.struct.query.Unions;
import db.sql.api.cmd.struct.query.Withs;
import db.sql.api.impl.cmd.CmdFactory;
import db.sql.api.impl.cmd.ConditionFactory;
import db.sql.api.impl.cmd.Methods;
import db.sql.api.impl.cmd.basic.Count1;
import db.sql.api.impl.cmd.basic.CountAll;
import db.sql.api.impl.cmd.basic.OrderByDirection;
import db.sql.api.impl.cmd.basic.Table;
import db.sql.api.impl.cmd.basic.TableField;
import db.sql.api.impl.cmd.executor.BaseExecutor;
import db.sql.api.impl.cmd.struct.ConditionChain;
import db.sql.api.impl.cmd.struct.ForUpdate;
import db.sql.api.impl.cmd.struct.From;
import db.sql.api.impl.cmd.struct.Join;
import db.sql.api.impl.cmd.struct.Limit;
import db.sql.api.impl.cmd.struct.On;
import db.sql.api.impl.cmd.struct.Where;
import db.sql.api.impl.cmd.struct.query.GroupBy;
import db.sql.api.impl.cmd.struct.query.Having;
import db.sql.api.impl.cmd.struct.query.OrderBy;
import db.sql.api.impl.cmd.struct.query.Select;
import db.sql.api.impl.cmd.struct.query.Union;
import db.sql.api.impl.cmd.struct.query.With;
import db.sql.api.impl.tookit.LambdaUtil;
import db.sql.api.impl.tookit.SqlConst;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractQuery<SELF extends AbstractQuery<SELF, CMD_FACTORY>, CMD_FACTORY extends CmdFactory>
extends BaseExecutor<SELF, CMD_FACTORY>
implements IQuery<SELF, Table, TableField, Cmd, Object, CMD_FACTORY, ConditionChain, With, Select, From, Join, On, Joins<Join>, Where, GroupBy, Having, OrderBy, Limit, ForUpdate, Union>,
Cmd {
    protected final ConditionFactory conditionFactory;
    protected final CMD_FACTORY $;
    protected Select select;
    protected Withs withs;
    protected From from;
    protected Where where;
    protected Joins joins;
    protected GroupBy groupBy;
    protected Having having;
    protected OrderBy orderBy;
    protected Limit limit;
    protected ForUpdate forUpdate;
    protected Unions unions;
    protected Map<String, Consumer<Where>> fetchFilters;

    public AbstractQuery(CMD_FACTORY $) {
        this.$ = $;
        this.conditionFactory = new ConditionFactory((CmdFactory)$);
    }

    public AbstractQuery(Where where) {
        this.$ = where.getConditionFactory().getCmdFactory();
        this.conditionFactory = where.getConditionFactory();
        this.where = where;
        this.append((Cmd)where);
    }

    @Override
    public CMD_FACTORY $() {
        return this.$;
    }

    public <T> TableField $(Getter<T> getter) {
        return this.$(getter, 1);
    }

    public <T> TableField $(Getter<T> getter, int storey) {
        return this.$().field((Getter)getter, storey);
    }

    public Table $(Class entityType) {
        return this.$(entityType, 1);
    }

    public Table $(Class entityType, int storey) {
        return this.$().table(entityType, storey);
    }

    public TableField $(Class entityType, String fieldName) {
        return this.$(entityType, fieldName, 1);
    }

    public TableField $(Class entityType, String fieldName, int storey) {
        return this.$().field(entityType, fieldName, storey);
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> DATASET_FIELD $(IDataset<DATASET, DATASET_FIELD> dataset, String columnName) {
        return this.$().field(dataset, columnName);
    }

    public <E, DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> DATASET_FIELD $(IDataset<DATASET, DATASET_FIELD> dataset, Getter<E> getter) {
        return this.$().field(dataset, getter);
    }

    public <T> SELF fetchFilter(Getter<T> getter, Consumer<Where> where) {
        LambdaUtil.LambdaFieldInfo lambdaFieldInfo = LambdaUtil.getFieldInfo(getter);
        String key = lambdaFieldInfo.getType().getName() + "." + lambdaFieldInfo.getName();
        if (Objects.isNull(this.fetchFilters)) {
            this.fetchFilters = new HashMap<String, Consumer<Where>>();
        }
        this.fetchFilters.put(key, where);
        return (SELF)this;
    }

    public Map<String, Consumer<Where>> getFetchFilters() {
        return this.fetchFilters;
    }

    @Override
    protected void initCmdSorts(Map<Class<? extends Cmd>, Integer> cmdSorts) {
        int i = 0;
        cmdSorts.put(Withs.class, i += 10);
        cmdSorts.put(Select.class, i += 10);
        cmdSorts.put(From.class, i += 10);
        cmdSorts.put(Joins.class, i += 10);
        cmdSorts.put(Where.class, i += 10);
        cmdSorts.put(GroupBy.class, i += 10);
        cmdSorts.put(Having.class, i += 10);
        cmdSorts.put(OrderBy.class, i += 10);
        cmdSorts.put(Limit.class, i += 10);
        cmdSorts.put(ForUpdate.class, i += 10);
        cmdSorts.put(Unions.class, i += 10);
        cmdSorts.put(UnionsCmdLists.class, i += 10);
    }

    public With $with(IWithQuery withQuery) {
        if (Objects.isNull(this.withs)) {
            this.withs = new Withs();
            this.append((Cmd)this.withs);
        }
        With with = new With(withQuery);
        this.withs.add((IWith)with);
        return with;
    }

    public Select $select() {
        if (this.select == null) {
            this.select = new Select();
            this.append((Cmd)this.select);
        }
        return this.select;
    }

    public SELF selectCount1() {
        this.select(Count1.INSTANCE);
        return (SELF)this;
    }

    public SELF selectCountAll() {
        this.select(CountAll.INSTANCE);
        return (SELF)this;
    }

    public <T> SELF select(Getter<T> column, int storey, Function<TableField, Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.select((Cmd)((CmdFactory)this.$).field((Getter)column, storey)));
        }
        return (SELF)((AbstractQuery)this.select(f.apply((TableField)((CmdFactory)this.$).field((Getter)column, storey))));
    }

    public SELF select(GetterField[] getterFields, Function<TableField[], Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.select(((CmdFactory)this.$).fields(getterFields)));
        }
        return (SELF)((AbstractQuery)this.select(f.apply(((CmdFactory)this.$).fields(getterFields))));
    }

    public <T> SELF select(int storey, Getter<T> ... columns) {
        return (SELF)((AbstractQuery)this.select(((CmdFactory)this.$).fields(storey, columns)));
    }

    public SELF select(String columnName) {
        return (SELF)((AbstractQuery)this.select(Methods.column(columnName)));
    }

    public SELF select(String columnName, Function<IDatasetField, Cmd> f) {
        return (SELF)((AbstractQuery)this.select(f.apply(Methods.column(columnName))));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF select(IDataset<DATASET, DATASET_FIELD> dataset, String columnName, Function<DATASET_FIELD, Cmd> f) {
        return (SELF)((AbstractQuery)this.select(f.apply(this.$(dataset, columnName))));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF select(IDataset<DATASET, DATASET_FIELD> dataset, GetterField[] getterFields, Function<IDatasetField[], Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.select((Cmd[])this.getDatasetFields(dataset, (IColumnField[])getterFields)));
        }
        return (SELF)((AbstractQuery)this.select(this.apply(dataset, f, (IColumnField[])getterFields)));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF select(IDataset<DATASET, DATASET_FIELD> dataset, String columnName) {
        return (SELF)((AbstractQuery)this.select((Cmd)this.$(dataset, columnName)));
    }

    public <T, DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF select(IDataset<DATASET, DATASET_FIELD> dataset, Getter<T> column, Function<DATASET_FIELD, Cmd> f) {
        return (SELF)((AbstractQuery)this.select(f.apply(this.$(dataset, column))));
    }

    public From $from(IDataset ... tables) {
        if (this.from == null) {
            this.from = new From();
            this.append((Cmd)this.from);
        }
        this.from.append(tables);
        return this.from;
    }

    public SELF from(Class entity, int storey, Consumer<Table> consumer) {
        this.fromEntityIntercept(entity, storey);
        ITable table = ((CmdFactory)this.$).table(entity, storey);
        this.from(new IDataset[]{table});
        if (Objects.nonNull(consumer)) {
            consumer.accept((Table)table);
        }
        return (SELF)this;
    }

    public Join $join(JoinMode mode, IDataset mainTable, IDataset secondTable) {
        Join join = new Join(mode, mainTable, secondTable, joinDataset -> new On(this.conditionFactory, (Join)joinDataset));
        if (Objects.isNull(this.joins)) {
            this.joins = new Joins();
            this.append((Cmd)this.joins);
        }
        this.joins.add((IJoin)join);
        return join;
    }

    public SELF join(JoinMode mode, Class mainTable, int mainTableStorey, Class secondTable, int secondTableStorey, Consumer<On> consumer) {
        consumer = this.joinEntityIntercept(mainTable, mainTableStorey, secondTable, secondTableStorey, consumer);
        return this.join(mode, ((CmdFactory)this.$).table(mainTable, mainTableStorey), ((CmdFactory)this.$).table(secondTable, secondTableStorey), (Consumer<On>)consumer);
    }

    public SELF join(JoinMode mode, Class mainTable, int mainTableStorey, Class secondTable, int secondTableStorey, BiConsumer<Table, On> consumer) {
        return this.join(mode, mainTable, mainTableStorey, secondTable, secondTableStorey, (On on) -> consumer.accept((Table)on.getJoin().getSecondTable(), (On)on));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF join(JoinMode mode, Class mainTable, int mainTableStorey, DATASET secondTable, Consumer<On> consumer) {
        return this.join(mode, ((CmdFactory)this.$).table(mainTable, mainTableStorey), secondTable, consumer);
    }

    public Where $where() {
        if (this.where == null) {
            this.where = new Where(this.conditionFactory);
            this.append((Cmd)this.where);
        }
        return this.where;
    }

    public <T> SELF and(Getter<T> column, int storey, Function<TableField, ICondition> f) {
        this.$where().and(column, storey, f);
        return (SELF)this;
    }

    public <T> SELF or(Getter<T> column, int storey, Function<TableField, ICondition> f) {
        this.$where().or(column, storey, f);
        return (SELF)this;
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>, DATASET2 extends IDataset<DATASET2, DATASET_FIELD2>, DATASET_FIELD2 extends IDatasetField<DATASET_FIELD2>> SELF join(JoinMode mode, DATASET mainTable, DATASET2 secondTable, Consumer<On> consumer) {
        Join join = this.$join(mode, mainTable, secondTable);
        if (consumer != null) {
            consumer.accept(join.getOn());
        }
        return (SELF)this;
    }

    public GroupBy $groupBy() {
        if (this.groupBy == null) {
            this.groupBy = new GroupBy();
            this.append((Cmd)this.groupBy);
        }
        return this.groupBy;
    }

    public <T> SELF groupBy(Getter<T> column, int storey, Function<TableField, Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.groupBy((Cmd)((CmdFactory)this.$).field((Getter)column, storey)));
        }
        return (SELF)((AbstractQuery)this.groupBy(f.apply((TableField)((CmdFactory)this.$).field((Getter)column, storey))));
    }

    public SELF groupBy(GetterField[] getterFields, Function<TableField[], Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.groupBy(((CmdFactory)this.$).fields(getterFields)));
        }
        return (SELF)((AbstractQuery)this.groupBy(f.apply(((CmdFactory)this.$).fields(getterFields))));
    }

    public <T> SELF groupBy(int storey, Getter<T> ... columns) {
        return (SELF)((AbstractQuery)this.groupBy(((CmdFactory)this.$).fields(storey, columns)));
    }

    public SELF groupBy(String columnName) {
        return (SELF)((AbstractQuery)this.groupBy(Methods.column(columnName)));
    }

    public SELF groupBy(String columnName, Function<IDatasetField, Cmd> f) {
        return (SELF)((AbstractQuery)this.groupBy(f.apply(Methods.column(columnName))));
    }

    public <T, DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF groupBy(IDataset<DATASET, DATASET_FIELD> dataset, Getter<T> column) {
        return (SELF)((AbstractQuery)this.groupBy((Cmd)this.$(dataset, column)));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF groupBy(IDataset<DATASET, DATASET_FIELD> dataset, String columnName, Function<DATASET_FIELD, Cmd> f) {
        return (SELF)((AbstractQuery)this.groupBy(f.apply(this.$(dataset, columnName))));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF groupBy(IDataset<DATASET, DATASET_FIELD> dataset, GetterField[] getterFields, Function<IDatasetField[], Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.groupBy((Cmd[])this.getDatasetFields(dataset, (IColumnField[])getterFields)));
        }
        return (SELF)((AbstractQuery)this.groupBy(this.apply(dataset, f, (IColumnField[])getterFields)));
    }

    public <T, DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF groupBy(IDataset<DATASET, DATASET_FIELD> dataset, Getter<T> column, Function<DATASET_FIELD, Cmd> f) {
        return (SELF)((AbstractQuery)this.groupBy(f.apply(this.$(dataset, column))));
    }

    public Having $having() {
        if (this.having == null) {
            this.having = new Having((CmdFactory)this.$);
            this.append((Cmd)this.having);
        }
        return this.having;
    }

    public <T> SELF havingAnd(boolean when, Getter<T> column, int storey, Function<TableField, ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingAnd(f.apply((TableField)((CmdFactory)this.$).field((Getter)column, storey))));
    }

    public <T> SELF havingOr(boolean when, Getter<T> column, int storey, Function<TableField, ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingOr(f.apply((TableField)((CmdFactory)this.$).field((Getter)column, storey))));
    }

    public <T, DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF havingAnd(boolean when, IDataset<DATASET, DATASET_FIELD> dataset, Getter<T> column, Function<DATASET_FIELD, ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingAnd(f.apply(this.$(dataset, column))));
    }

    public <T, DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF havingOr(boolean when, IDataset<DATASET, DATASET_FIELD> dataset, Getter<T> column, Function<DATASET_FIELD, ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingOr(f.apply(this.$(dataset, column))));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF havingAnd(IDataset<DATASET, DATASET_FIELD> dataset, String columnName, Function<DATASET_FIELD, ICondition> f) {
        return (SELF)((AbstractQuery)this.havingAnd(f.apply(this.$(dataset, columnName))));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF havingOr(IDataset<DATASET, DATASET_FIELD> dataset, String columnName, Function<DATASET_FIELD, ICondition> f) {
        return (SELF)((AbstractQuery)this.havingOr(f.apply(this.$(dataset, columnName))));
    }

    public SELF havingAnd(boolean when, GetterField[] getterFields, Function<TableField[], ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingAnd(f.apply(((CmdFactory)this.$).fields(getterFields))));
    }

    public SELF havingOr(boolean when, GetterField[] getterFields, Function<TableField[], ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingOr(f.apply(((CmdFactory)this.$).fields(getterFields))));
    }

    private <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> IDatasetField[] getDatasetFields(IDataset<DATASET, DATASET_FIELD> dataset, IColumnField ... columnFields) {
        IDatasetField[] datasetFields = new IDatasetField[columnFields.length];
        for (int i = 0; i < columnFields.length; ++i) {
            IColumnField columnField = columnFields[i];
            if (columnField instanceof ColumnField) {
                datasetFields[i] = this.$(dataset, ((ColumnField)columnField).getColumnName());
                continue;
            }
            if (columnField instanceof GetterField) {
                datasetFields[i] = this.$(dataset, ((GetterField)columnField).getGetter());
                continue;
            }
            throw new RuntimeException("Not Supported");
        }
        return datasetFields;
    }

    private <R, DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> R apply(IDataset<DATASET, DATASET_FIELD> dataset, Function<IDatasetField[], R> f, IColumnField ... columnFields) {
        return f.apply(this.getDatasetFields(dataset, columnFields));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF havingAnd(boolean when, IDataset<DATASET, DATASET_FIELD> dataset, String columnName, Function<DATASET_FIELD, ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingAnd(f.apply(this.$(dataset, columnName))));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF havingOr(boolean when, IDataset<DATASET, DATASET_FIELD> dataset, String columnName, Function<DATASET_FIELD, ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingOr(f.apply(this.$(dataset, columnName))));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF havingAnd(boolean when, IDataset<DATASET, DATASET_FIELD> dataset, GetterField[] getterFields, Function<IDatasetField[], ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingAnd(this.apply(dataset, f, (IColumnField[])getterFields)));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF havingOr(boolean when, IDataset<DATASET, DATASET_FIELD> dataset, GetterField[] getterFields, Function<IDatasetField[], ICondition> f) {
        if (!when) {
            return (SELF)this;
        }
        return (SELF)((AbstractQuery)this.havingOr(this.apply(dataset, f, (IColumnField[])getterFields)));
    }

    public OrderBy $orderBy() {
        if (this.orderBy == null) {
            this.orderBy = new OrderBy();
            this.append((Cmd)this.orderBy);
        }
        return this.orderBy;
    }

    public IOrderByDirection ascOrderByDirection() {
        return OrderByDirection.ASC;
    }

    public IOrderByDirection descOrderByDirection() {
        return OrderByDirection.DESC;
    }

    public ForUpdate $forUpdate() {
        if (this.forUpdate == null) {
            this.forUpdate = new ForUpdate();
            this.append((Cmd)this.forUpdate);
        }
        return this.forUpdate;
    }

    public Limit $limit() {
        if (this.limit == null) {
            this.limit = new Limit(0, 0);
            this.append((Cmd)this.limit);
        }
        return this.limit;
    }

    public <T> SELF orderBy(IOrderByDirection orderByDirection, Getter<T> column, int storey, Function<TableField, Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.orderBy(orderByDirection, (Cmd)((CmdFactory)this.$).field((Getter)column, storey)));
        }
        return (SELF)((AbstractQuery)this.orderBy(orderByDirection, f.apply((TableField)((CmdFactory)this.$).field((Getter)column, storey))));
    }

    public SELF orderBy(IOrderByDirection orderByDirection, GetterField[] getterFields, Function<TableField[], Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.orderBy(orderByDirection, ((CmdFactory)this.$).fields(getterFields)));
        }
        return (SELF)((AbstractQuery)this.orderBy(orderByDirection, f.apply(((CmdFactory)this.$).fields(getterFields))));
    }

    public <T> SELF orderBy(IOrderByDirection orderByDirection, int storey, Getter<T> ... columns) {
        return (SELF)((AbstractQuery)this.orderBy(orderByDirection, ((CmdFactory)this.$).fields(storey, columns)));
    }

    public SELF orderBy(IOrderByDirection orderByDirection, String columnName) {
        return (SELF)((AbstractQuery)this.orderBy(orderByDirection, Methods.column(columnName)));
    }

    public SELF orderBy(IOrderByDirection orderByDirection, String columnName, Function<IDatasetField, Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.orderBy(orderByDirection, Methods.column(columnName)));
        }
        return (SELF)((AbstractQuery)this.orderBy(orderByDirection, f.apply(Methods.column(columnName))));
    }

    public <T, DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF orderBy(IDataset<DATASET, DATASET_FIELD> dataset, IOrderByDirection orderByDirection, Getter<T> column, Function<DATASET_FIELD, Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.orderBy(orderByDirection, (Cmd)this.$(dataset, column)));
        }
        return (SELF)((AbstractQuery)this.orderBy(orderByDirection, f.apply(this.$(dataset, column))));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF orderBy(IDataset<DATASET, DATASET_FIELD> dataset, IOrderByDirection orderByDirection, String columnName, Function<DATASET_FIELD, Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.orderBy(orderByDirection, (Cmd)this.$(dataset, columnName)));
        }
        return (SELF)((AbstractQuery)this.orderBy(orderByDirection, f.apply(this.$(dataset, columnName))));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF orderBy(IDataset<DATASET, DATASET_FIELD> dataset, IOrderByDirection orderByDirection, GetterField[] getterFields, Function<IDatasetField[], Cmd> f) {
        if (Objects.isNull(f)) {
            return (SELF)((AbstractQuery)this.orderBy(orderByDirection, (Cmd[])this.getDatasetFields(dataset, (IColumnField[])getterFields)));
        }
        return (SELF)((AbstractQuery)this.orderBy(orderByDirection, this.apply(dataset, f, (IColumnField[])getterFields)));
    }

    public <DATASET extends IDataset<DATASET, DATASET_FIELD>, DATASET_FIELD extends IDatasetField<DATASET_FIELD>> SELF orderBy(IDataset<DATASET, DATASET_FIELD> dataset, IOrderByDirection orderByDirection, String columnName) {
        return (SELF)((AbstractQuery)this.orderBy(orderByDirection, (Cmd)this.$(dataset, columnName)));
    }

    public Unions $unions() {
        if (this.unions == null) {
            this.unions = new Unions();
            this.cmds.add(this.unions);
        }
        return this.unions;
    }

    public SELF union(IQuery unionQuery) {
        this.$unions().add((IUnion)new Union(unionQuery));
        return (SELF)this;
    }

    public SELF unionAll(IQuery unionQuery) {
        this.$unions().add((IUnion)new Union(SqlConst.UNION_ALL, unionQuery));
        return (SELF)this;
    }

    public Select getSelect() {
        return this.select;
    }

    public From getFrom() {
        return this.from;
    }

    public Joins getJoins() {
        return this.joins;
    }

    public Where getWhere() {
        return this.where;
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public Unions getUnions() {
        return this.unions;
    }

    public ForUpdate getForUpdate() {
        return this.forUpdate;
    }
}

