/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.cmd.executor;

import db.sql.api.Cmd;
import db.sql.api.DbType;
import db.sql.api.impl.cmd.CmdFactory;
import db.sql.api.impl.cmd.executor.DbSelector;
import db.sql.api.impl.cmd.executor.Executor;
import db.sql.api.impl.cmd.executor.Selector;
import db.sql.api.tookit.CmdUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public abstract class BaseExecutor<SELF extends BaseExecutor<SELF, CMD_FACTORY>, CMD_FACTORY extends CmdFactory>
implements Executor<SELF, CMD_FACTORY> {
    protected final List<Cmd> cmds = new ArrayList<Cmd>();
    private final Map<Class<? extends Cmd>, Integer> cmdSorts = new HashMap<Class<? extends Cmd>, Integer>();
    private List<Selector> selectors;
    private boolean isExecuteSelector = false;

    public BaseExecutor() {
        this.initCmdSorts(this.cmdSorts);
    }

    private Selector createSelector() {
        if (Objects.isNull(this.selectors)) {
            this.selectors = new ArrayList<Selector>();
        }
        DbSelector dbSelector = new DbSelector();
        this.selectors.add(dbSelector);
        return dbSelector;
    }

    @Override
    public SELF dbAdapt(BiConsumer<SELF, Selector> consumer) {
        BaseExecutor self = this;
        consumer.accept(self, this.createSelector());
        return (SELF)this;
    }

    public void selectorExecute(DbType dbType) {
        if (this.isExecuteSelector) {
            return;
        }
        this.isExecuteSelector = true;
        if (Objects.isNull(this.selectors)) {
            return;
        }
        this.selectors.forEach(dbSelector -> dbSelector.dbExecute(dbType));
    }

    public List<Cmd> cmds() {
        return this.cmds;
    }

    protected void append(Cmd cmd) {
        this.cmds.add(cmd);
    }

    public Map<Class<? extends Cmd>, Integer> cmdSorts() {
        return this.cmdSorts;
    }

    abstract void initCmdSorts(Map<Class<? extends Cmd>, Integer> var1);

    public boolean contain(Cmd cmd) {
        return CmdUtils.contain((Cmd)cmd, this.cmds);
    }
}

