/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.tookit;

import db.sql.api.GetterFun;
import db.sql.api.impl.tookit.PropertyNamer;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.util.MapUtil;

public final class LambdaUtil {
    private static final Map<GetterFun, LambdaFieldInfo> LAMBDA_GETTER_FIELD_MAP = new ConcurrentHashMap<GetterFun, LambdaFieldInfo>(65535);
    private static final Map<String, Class<?>> CLASS_MAP = new ConcurrentHashMap();

    private LambdaUtil() {
    }

    public static <T, R> String getName(GetterFun<T, R> getter) {
        return LambdaUtil.getFieldInfo(getter).getName();
    }

    private static LambdaFieldInfo getLambdaFieldInfo(SerializedLambda serializedLambda, ClassLoader classLoader) {
        Class type = LambdaUtil.getClass(serializedLambda, classLoader);
        String methodName = serializedLambda.getImplMethodName();
        String fieldName = PropertyNamer.methodToProperty(methodName);
        return new LambdaFieldInfo(type, fieldName);
    }

    public static <T, R> LambdaFieldInfo getFieldInfo(GetterFun<T, R> getter) {
        return LAMBDA_GETTER_FIELD_MAP.computeIfAbsent(getter, key -> LambdaUtil.getLambdaFieldInfo(LambdaUtil.getSerializedLambda(getter), getter.getClass().getClassLoader()));
    }

    private static <T, R> SerializedLambda getSerializedLambda(GetterFun<T, R> getter) {
        try {
            Method method = getter.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            return (SerializedLambda)method.invoke(getter, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> Class<T> getClass(SerializedLambda lambda, ClassLoader classLoader) {
        String classNamePath = LambdaUtil.getClassNamePath(lambda);
        return (Class)MapUtil.computeIfAbsent(CLASS_MAP, (Object)classNamePath, key -> {
            try {
                return Class.forName(LambdaUtil.getClassName(key), false, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static String getClassName(String classNamePath) {
        return classNamePath.replace("/", ".");
    }

    private static String getClassNamePath(SerializedLambda lambda) {
        String type = lambda.getInstantiatedMethodType();
        return type.substring(2, type.indexOf(";"));
    }

    public static void main(String[] args) {
        System.out.println(LambdaUtil.getName(LambdaFieldInfo::getName));
        System.out.println(LambdaUtil.getName(LambdaFieldInfo::getName));
        System.out.println(LAMBDA_GETTER_FIELD_MAP.size());
    }

    public static class LambdaFieldInfo {
        private final Class type;
        private final String name;

        public LambdaFieldInfo(Class type, String name) {
            this.type = type;
            this.name = name;
        }

        public Class getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }
}

