/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.tookit;

import db.sql.api.Cmd;
import db.sql.api.DbType;
import db.sql.api.SqlBuilderContext;
import db.sql.api.cmd.JoinMode;
import db.sql.api.cmd.basic.CmdList;
import db.sql.api.cmd.basic.SQL1;
import db.sql.api.cmd.basic.UnionsCmdLists;
import db.sql.api.cmd.executor.IQuery;
import db.sql.api.cmd.struct.Joins;
import db.sql.api.cmd.struct.query.IUnion;
import db.sql.api.cmd.struct.query.Unions;
import db.sql.api.impl.cmd.basic.CountAll;
import db.sql.api.impl.cmd.dbFun.Count;
import db.sql.api.impl.cmd.struct.Join;
import db.sql.api.impl.cmd.struct.Limit;
import db.sql.api.impl.cmd.struct.query.GroupBy;
import db.sql.api.impl.cmd.struct.query.OrderBy;
import db.sql.api.impl.cmd.struct.query.Select;
import db.sql.api.impl.tookit.Objects;
import db.sql.api.impl.tookit.OptimizeOptions;
import db.sql.api.tookit.CmdUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class SQLOptimizeUtils {
    public static int getStringBuilderCapacity(List<Cmd> cmds) {
        return 16;
    }

    private static boolean isCanRemoveLeftJoin(Join current, List<Join> joinList, boolean forClass, Map<Class, Cmd> classCmdMap) {
        for (Join join : joinList) {
            if (join == current || !join.getOn().contain((Cmd)current.getSecondTable())) continue;
            return false;
        }
        for (Map.Entry entry : classCmdMap.entrySet()) {
            Select select;
            Class c = (Class)entry.getKey();
            if (c == Joins.class || !(forClass && c == Select.class ? (select = (Select)entry.getValue()).isDistinct() && select.contain((Cmd)current.getSecondTable()) : ((Cmd)entry.getValue()).contain((Cmd)current.getSecondTable()))) continue;
            return false;
        }
        return true;
    }

    private static boolean removeLeftJoin(List<Join> joinList, boolean forCount, Map<Class, Cmd> classCmdMap) {
        boolean remove;
        boolean hasLeftJoin = false;
        for (Join join : joinList) {
            if (join.getMode() != JoinMode.LEFT) continue;
            hasLeftJoin = true;
            break;
        }
        if (!hasLeftJoin) {
            return false;
        }
        boolean removeOne = false;
        int size = joinList.size();
        block1: do {
            remove = false;
            for (int i = size - 1; i >= 0; --i) {
                Join join = joinList.get(i);
                if (join.getMode() != JoinMode.LEFT || !SQLOptimizeUtils.isCanRemoveLeftJoin(join, joinList, forCount, classCmdMap)) continue;
                removeOne = true;
                remove = true;
                joinList.remove(i);
                --size;
                continue block1;
            }
        } while (remove);
        return removeOne;
    }

    private static void optimizedCmdList(DbType dbType, Map<Class, Cmd> classCmdMap, boolean forCount, boolean optimizeOrderBy, boolean optimizeJoins, boolean isUnionQuery) {
        Unions unions;
        ArrayList<Join> joinList;
        Joins joins;
        if (forCount && !isUnionQuery) {
            classCmdMap.remove(Limit.class);
        }
        if (optimizeOrderBy) {
            if (isUnionQuery) {
                if (!classCmdMap.containsKey(Limit.class)) {
                    classCmdMap.remove(OrderBy.class);
                }
            } else {
                classCmdMap.remove(OrderBy.class);
            }
        }
        if (optimizeJoins && Objects.nonNull(joins = (Joins)classCmdMap.get(Joins.class)) && SQLOptimizeUtils.removeLeftJoin(joinList = new ArrayList<Join>(joins.getJoins()), forCount, classCmdMap)) {
            if (joinList.isEmpty()) {
                classCmdMap.remove(Joins.class);
            } else {
                classCmdMap.put(Joins.class, (Cmd)new Joins(joinList));
            }
        }
        if (Objects.nonNull(unions = (Unions)classCmdMap.get(Unions.class)) && (optimizeOrderBy || optimizeJoins)) {
            List unionList = unions.getUnions();
            int size = unionList.size();
            ArrayList<CmdList> cmdListList = new ArrayList<CmdList>(size);
            for (IUnion union : unionList) {
                HashMap<Class, Cmd> unionCmdClassMap = new HashMap<Class, Cmd>();
                List unionCmdList = union.getUnionQuery().cmds();
                for (Cmd unionCmd : unionCmdList) {
                    unionCmdClassMap.put(unionCmd.getClass(), unionCmd);
                }
                SQLOptimizeUtils.optimizedCmdList(dbType, unionCmdClassMap, false, optimizeOrderBy, optimizeJoins, true);
                unionCmdList = unionCmdClassMap.values().stream().sorted(union.getUnionQuery().comparator()).collect(Collectors.toList());
                CmdList cmdList = new CmdList(union.getOperator(), unionCmdList);
                cmdListList.add(cmdList);
            }
            classCmdMap.remove(Unions.class);
            classCmdMap.put(UnionsCmdLists.class, (Cmd)new UnionsCmdLists(cmdListList));
        }
        Select select = (Select)classCmdMap.get(Select.class);
        if (forCount && !isUnionQuery && !select.isDistinct()) {
            Select newSelect = dbType == DbType.ORACLE ? (classCmdMap.containsKey(GroupBy.class) ? select : new Select().select((Cmd)SQL1.INSTANCE)) : new Select().select((Cmd)SQL1.INSTANCE);
            classCmdMap.put(Select.class, (Cmd)newSelect);
        }
    }

    public static StringBuilder getOptimizedSql(IQuery query, SqlBuilderContext context, OptimizeOptions optimizeOptions) {
        if (!optimizeOptions.isOptimizeJoin()) {
            return query.sql(context, new StringBuilder(SQLOptimizeUtils.getStringBuilderCapacity(query.cmds())));
        }
        if (query.getJoins() == null) {
            return query.sql(context, new StringBuilder(SQLOptimizeUtils.getStringBuilderCapacity(query.cmds())));
        }
        HashMap<Class, Cmd> classCmdMap = new HashMap<Class, Cmd>();
        List<Cmd> cmdList = query.cmds();
        for (Cmd cmd : cmdList) {
            classCmdMap.put(cmd.getClass(), cmd);
        }
        SQLOptimizeUtils.optimizedCmdList(context.getDbType(), classCmdMap, false, false, true, classCmdMap.containsKey(Unions.class));
        cmdList = classCmdMap.values().stream().sorted(query.comparator()).collect(Collectors.toList());
        return CmdUtils.join((SqlBuilderContext)context, (StringBuilder)new StringBuilder(SQLOptimizeUtils.getStringBuilderCapacity(cmdList)), cmdList);
    }

    public static StringBuilder getOptimizedCountSql(IQuery query, SqlBuilderContext context, boolean optimizeOrderBy, boolean optimizeJoins) {
        HashMap<Class, Cmd> classCmdMap = new HashMap<Class, Cmd>();
        List<Cmd> cmdList = query.cmds();
        int size = cmdList.size();
        for (Cmd cmd : cmdList) {
            classCmdMap.put(cmd.getClass(), cmd);
        }
        SQLOptimizeUtils.optimizedCmdList(context.getDbType(), classCmdMap, true, optimizeOrderBy, optimizeJoins, classCmdMap.containsKey(Unions.class));
        boolean needWarp = false;
        if (classCmdMap.containsKey(Unions.class) || classCmdMap.containsKey(UnionsCmdLists.class)) {
            needWarp = true;
        } else if (classCmdMap.containsKey(GroupBy.class)) {
            needWarp = true;
        }
        if (!needWarp) {
            Select select = (Select)classCmdMap.get(Select.class);
            Select newSelect = new Select();
            if (select.isDistinct()) {
                newSelect.select((Cmd)new Count((Cmd)select));
            } else {
                newSelect.select((Cmd)CountAll.INSTANCE);
            }
            classCmdMap.put(Select.class, (Cmd)newSelect);
        }
        cmdList = classCmdMap.values().stream().sorted(query.comparator()).collect(Collectors.toList());
        if (needWarp) {
            return new StringBuilder("SELECT COUNT(*) FROM (").append((CharSequence)CmdUtils.join((SqlBuilderContext)context, (StringBuilder)new StringBuilder(SQLOptimizeUtils.getStringBuilderCapacity(cmdList)), cmdList)).append(") T");
        }
        return CmdUtils.join((SqlBuilderContext)context, (StringBuilder)new StringBuilder(SQLOptimizeUtils.getStringBuilderCapacity(cmdList)), cmdList);
    }

    public static StringBuilder getCountSqlFromQuery(IQuery query, SqlBuilderContext context, OptimizeOptions optimizeOptions) {
        if (optimizeOptions.isAllDisable()) {
            if (context.getDbType() == DbType.SQL_SERVER || context.getDbType() == DbType.ORACLE) {
                return SQLOptimizeUtils.getOptimizedCountSql(query, context, true, false);
            }
            return new StringBuilder("SELECT COUNT(*) FROM (").append((CharSequence)CmdUtils.join((SqlBuilderContext)context, (StringBuilder)new StringBuilder(SQLOptimizeUtils.getStringBuilderCapacity(query.cmds())), (List)query.sortedCmds())).append(") T");
        }
        return SQLOptimizeUtils.getOptimizedCountSql(query, context, optimizeOptions.isOptimizeOrderBy(), optimizeOptions.isOptimizeJoin());
    }

    public static StringBuilder getOptimizedCountSql(IQuery query, SqlBuilderContext context, OptimizeOptions optimizeOptions) {
        if (optimizeOptions.isAllDisable()) {
            return query.sql(context, new StringBuilder(SQLOptimizeUtils.getStringBuilderCapacity(query.cmds())));
        }
        return SQLOptimizeUtils.getOptimizedCountSql(query, context, optimizeOptions.isOptimizeOrderBy(), optimizeOptions.isOptimizeJoin());
    }
}

