/*
 * Decompiled with CFR 0.152.
 */
package db.sql.api.impl.tookit;

import db.sql.api.Getter;
import db.sql.api.impl.tookit.LambdaUtil;
import java.lang.reflect.Field;

public final class SqlUtil {
    private static final String AS_SPLIT = "$$";

    public static <T> String getAsName(Getter<T> getter) {
        LambdaUtil.LambdaFieldInfo lambdaFieldInfo = LambdaUtil.getFieldInfo(getter);
        return String.format("%s%s%s", lambdaFieldInfo.getType().getSimpleName(), AS_SPLIT, lambdaFieldInfo.getName());
    }

    public static String getFiledLambdaAsName(Field field) {
        return String.format("%s%s%s", field.getDeclaringClass().getSimpleName(), AS_SPLIT, field.getName());
    }

    public static String getAsName(Field field) {
        return String.format("%s%s%s", field.getDeclaringClass().getSimpleName(), AS_SPLIT, field.getName());
    }

    public static boolean isAsName(Field field, String name) {
        if (!name.contains(AS_SPLIT)) {
            return false;
        }
        return SqlUtil.getAsName(field).equals(name);
    }
}

