/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.boot;

import cn.zhxu.bs.boot.prop.BeanSearcherFieldConvertor;
import cn.zhxu.bs.boot.prop.BeanSearcherParams;
import cn.zhxu.bs.convertor.JsonFieldConvertor;
import cn.zhxu.bs.filter.JsonArrayParamFilter;
import cn.zhxu.xjson.JsonKit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@ConditionalOnClass(value={JsonKit.class})
public class BeanSearcherConfigOnJsonKit {
    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-json"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={JsonFieldConvertor.class})
    public JsonFieldConvertor jsonFieldConvertor(BeanSearcherFieldConvertor config) {
        return new JsonFieldConvertor(config.isJsonFailOnError());
    }

    @Bean
    @Order(value=300)
    @ConditionalOnMissingBean(value={JsonArrayParamFilter.class})
    @ConditionalOnProperty(name={"bean-searcher.params.filter.use-json-array"}, havingValue="true")
    public JsonArrayParamFilter jsonArrayParamFilter(BeanSearcherParams config) {
        return new JsonArrayParamFilter(config.getSeparator());
    }
}

