/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.boot;

import cn.zhxu.bs.FieldOpPool;
import cn.zhxu.bs.boot.prop.BeanSearcherParams;
import cn.zhxu.bs.filter.ArrayValueParamFilter;
import cn.zhxu.bs.filter.IndexArrayParamFilter;
import cn.zhxu.bs.filter.SizeLimitParamFilter;
import cn.zhxu.bs.filter.SuffixOpParamFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
public class BeanSearcherParamFilters {
    @Bean
    @Order(value=-100)
    @ConditionalOnMissingBean(value={SizeLimitParamFilter.class})
    @ConditionalOnProperty(name={"bean-searcher.params.filter.use-size-limit"}, havingValue="true", matchIfMissing=true)
    public SizeLimitParamFilter sizeLimitParamFilter(BeanSearcherParams config) {
        return new SizeLimitParamFilter(config.getFilter().getMaxParaMapSize());
    }

    @Bean
    @Order(value=100)
    @ConditionalOnMissingBean(value={ArrayValueParamFilter.class})
    @ConditionalOnProperty(name={"bean-searcher.params.filter.use-array-value"}, havingValue="true", matchIfMissing=true)
    public ArrayValueParamFilter arrayValueParamFilter(BeanSearcherParams config) {
        return new ArrayValueParamFilter(config.getSeparator());
    }

    @Bean
    @Order(value=200)
    @ConditionalOnMissingBean(value={SuffixOpParamFilter.class})
    @ConditionalOnProperty(name={"bean-searcher.params.filter.use-suffix-op"}, havingValue="true")
    public SuffixOpParamFilter suffixOpParamFilter(FieldOpPool fieldOpPool, BeanSearcherParams cfg) {
        return new SuffixOpParamFilter(fieldOpPool, cfg.getSeparator(), cfg.getOperatorKey(), cfg.getIgnoreCaseKey());
    }

    @Bean
    @Order(value=400)
    @ConditionalOnMissingBean(value={IndexArrayParamFilter.class})
    @ConditionalOnProperty(name={"bean-searcher.params.filter.use-index-array"}, havingValue="true")
    public IndexArrayParamFilter indexArrayParamFilter(BeanSearcherParams config) {
        return new IndexArrayParamFilter(config.getSeparator());
    }
}

