/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.convertor;

import cn.zhxu.bs.FieldConvertor;
import cn.zhxu.bs.FieldMeta;
import cn.zhxu.bs.bean.DbType;
import cn.zhxu.bs.util.StringUtils;
import cn.zhxu.xjson.JsonKit;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFieldConvertor
implements FieldConvertor.BFieldConvertor {
    static final Logger log = LoggerFactory.getLogger(JsonFieldConvertor.class);
    private boolean failOnError = true;

    public JsonFieldConvertor() {
    }

    public JsonFieldConvertor(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Override
    public boolean supports(FieldMeta meta, Class<?> valueType) {
        return meta.getType() != String.class && meta.getDbType() == DbType.JSON;
    }

    @Override
    public Object convert(FieldMeta meta, Object value) {
        String json = this.unwrap(this.jsonStr(value));
        if (StringUtils.isBlank(json)) {
            return null;
        }
        if (this.failOnError) {
            return this.doConvert(meta, json);
        }
        try {
            return this.doConvert(meta, json);
        }
        catch (Exception e) {
            log.warn("Json parse error [{}] for {}, the value is: {}", new Object[]{e.getClass().getName(), meta.getType(), json});
            return null;
        }
    }

    protected String unwrap(String json) {
        if (json.length() > 1 && json.charAt(0) == '\"' && json.charAt(json.length() - 1) == '\"') {
            return (String)JsonKit.toBean(String.class, (String)json);
        }
        return json;
    }

    protected String jsonStr(Object value) {
        if (value instanceof byte[]) {
            return new String((byte[])value, StandardCharsets.UTF_8);
        }
        return value.toString();
    }

    protected Object doConvert(FieldMeta meta, String json) {
        Type genericType = meta.getField().getGenericType();
        return JsonKit.toBean((Type)genericType, (String)json);
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

