/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.convertor;

import cn.zhxu.bs.FieldConvertor;
import cn.zhxu.bs.FieldMeta;
import cn.zhxu.bs.bean.DbType;
import cn.zhxu.bs.util.StringUtils;
import java.sql.Time;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeParamConvertor
implements FieldConvertor.ParamConvertor {
    static final Pattern TIME_PATTERN_1 = Pattern.compile("[0-9]{2}:[0-9]{2}:[0-9]{2}");
    static final Pattern TIME_PATTERN_2 = Pattern.compile("[0-9]{2}:[0-9]{2}");
    static final DateTimeFormatter FORMATTER_1 = DateTimeFormatter.ofPattern("HH:mm:ss");
    static final DateTimeFormatter FORMATTER_2 = DateTimeFormatter.ofPattern("HH:mm");
    private Target target = Target.SQL_TIME;

    public TimeParamConvertor() {
    }

    public TimeParamConvertor(Target target) {
        this.target = Objects.requireNonNull(target);
    }

    @Override
    public boolean supports(FieldMeta meta, Class<?> valueType) {
        return meta.getDbType() == DbType.TIME && (String.class == valueType || LocalTime.class == valueType || Time.class == valueType);
    }

    @Override
    public Object convert(FieldMeta meta, Object value) {
        if (value instanceof String) {
            String s = ((String)value).trim();
            if (StringUtils.isBlank(s)) {
                return null;
            }
            TemporalQuery<LocalTime> query = TemporalQueries.localTime();
            Matcher matcher1 = TIME_PATTERN_1.matcher(s);
            if (matcher1.find()) {
                return this.toTime(FORMATTER_1.parse((CharSequence)matcher1.group(), query));
            }
            Matcher matcher2 = TIME_PATTERN_2.matcher(s);
            if (matcher2.find()) {
                return this.toTime(FORMATTER_2.parse((CharSequence)matcher2.group(), query));
            }
        }
        if (value instanceof LocalTime) {
            return this.toTime((LocalTime)value);
        }
        if (value instanceof Time && this.target == Target.LOCAL_TIME) {
            return ((Time)value).toLocalTime();
        }
        return value;
    }

    private Object toTime(LocalTime time) {
        if (this.target == Target.SQL_TIME) {
            return Time.valueOf(time);
        }
        return time;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = Objects.requireNonNull(target);
    }

    public static enum Target {
        SQL_TIME,
        LOCAL_TIME;

    }
}

