/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.dialect;

import cn.zhxu.bs.SearchException;
import cn.zhxu.bs.SqlWrapper;
import cn.zhxu.bs.dialect.Dialect;
import cn.zhxu.bs.param.Paging;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DynamicDialect
implements Dialect {
    private static final ThreadLocal<String> holder = new ThreadLocal();
    private final Map<String, Dialect> dialectMap = new ConcurrentHashMap<String, Dialect>();
    private String defaultKey = "default";

    public static void setCurrent(String dataSource) {
        holder.set(dataSource);
    }

    public String currentKey() {
        String key = holder.get();
        if (key == null) {
            return this.defaultKey;
        }
        return key;
    }

    public Dialect lookup() {
        String key = this.currentKey();
        Dialect dialect = this.dialectMap.get(key);
        if (dialect == null) {
            throw new SearchException("No Dialect for dataSource: " + key);
        }
        return dialect;
    }

    @Override
    public void toUpperCase(StringBuilder builder, String dbField) {
        this.lookup().toUpperCase(builder, dbField);
    }

    @Override
    public SqlWrapper<Object> forPaginate(String fieldSelectSql, String fromWhereSql, Paging paging) {
        return this.lookup().forPaginate(fieldSelectSql, fromWhereSql, paging);
    }

    @Override
    public boolean hasILike() {
        return this.lookup().hasILike();
    }

    @Override
    public boolean allowHavingAlias() {
        return this.lookup().allowHavingAlias();
    }

    public String getDefaultKey() {
        return this.defaultKey;
    }

    public void setDefaultKey(String defaultKey) {
        this.dialectMap.put(defaultKey, this.dialectMap.get(this.defaultKey));
        this.defaultKey = defaultKey;
    }

    public void put(String dataSource, Dialect dialect) {
        this.dialectMap.put(dataSource, dialect);
    }

    public void put(Map<String, Dialect> dialectMap) {
        this.dialectMap.putAll(dialectMap);
    }

    public void setDefaultDialect(Dialect dialect) {
        this.dialectMap.put(this.defaultKey, dialect);
    }

    public Map<String, Dialect> getDialectMap() {
        return this.dialectMap;
    }
}

