/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.filter;

import cn.zhxu.bs.BeanMeta;
import cn.zhxu.bs.IllegalParamException;
import cn.zhxu.bs.ParamFilter;
import cn.zhxu.bs.util.RpcNames;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IndexArrayParamFilter
implements ParamFilter {
    static final Pattern KEY_PATTERN = Pattern.compile("([a-zA-Z0-9_]+)\\[([0-9]+)]");
    private final String separator;

    public IndexArrayParamFilter() {
        this(RpcNames.DEFAULT.separator());
    }

    public IndexArrayParamFilter(String separator) {
        this.separator = Objects.requireNonNull(separator);
    }

    @Override
    public <T> Map<String, Object> doFilter(BeanMeta<T> beanMeta, Map<String, Object> paraMap) throws IllegalParamException {
        HashMap<String, Object> newMap = null;
        for (Map.Entry<String, Object> entry : paraMap.entrySet()) {
            Matcher matcher;
            String key = entry.getKey();
            if (key == null || key.charAt(key.length() - 1) != ']' || !(matcher = KEY_PATTERN.matcher(key)).matches()) continue;
            if (newMap == null) {
                newMap = new HashMap<String, Object>();
            }
            String field = matcher.group(1);
            String index = matcher.group(2);
            newMap.put(field + this.separator + index, entry.getValue());
        }
        if (newMap != null) {
            paraMap.putAll(newMap);
        }
        return paraMap;
    }

    public String getSeparator() {
        return this.separator;
    }
}

