/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.group;

import cn.zhxu.bs.group.ExprParser;
import cn.zhxu.bs.group.Group;
import cn.zhxu.bs.util.StringUtils;
import java.util.Stack;

public class DefaultExprParser
implements ExprParser {
    private final String expression;
    private final Stack<Group<String>> valueStack = new Stack();
    private final Stack<Character> opStack = new Stack();
    private int index = 0;

    public DefaultExprParser(String expression) {
        this.expression = expression;
    }

    @Override
    public Group<String> parse() {
        Object res = this.readNext();
        while (res != null) {
            if (res instanceof String) {
                String value = (String)res;
                if (StringUtils.isNotBlank(value)) {
                    this.valueStack.push(new Group<String>(value));
                }
            } else if (res instanceof Character) {
                this.onReadOperator(((Character)res).charValue());
            }
            res = this.readNext();
        }
        return this.getResult();
    }

    protected Object readNext() {
        int initIndex = this.index;
        while (this.index < this.expression.length()) {
            char ch = this.expression.charAt(this.index);
            if (ch == '&' || ch == '|' || ch == '(' || ch == ')') {
                if (this.index == initIndex) {
                    ++this.index;
                    return Character.valueOf(ch);
                }
                return this.expression.substring(initIndex, this.index).trim();
            }
            ++this.index;
        }
        if (this.index > initIndex) {
            return this.expression.substring(initIndex, this.index).trim();
        }
        return null;
    }

    protected void onReadOperator(char op) {
        if (op != '(') {
            while (!this.opStack.isEmpty()) {
                char topOp = this.opStack.pop().charValue();
                if (op == ')') {
                    if (topOp == '(') {
                        return;
                    }
                } else if (topOp == '(' || op == '&' && topOp == '|') {
                    this.opStack.push(Character.valueOf(topOp));
                    break;
                }
                this.updateValueStack(topOp);
            }
        }
        this.opStack.push(Character.valueOf(op));
    }

    protected void updateValueStack(char op) {
        Group<String> value2 = this.valueStack.pop();
        Group<String> value1 = this.valueStack.pop();
        if (op == '&') {
            this.valueStack.push(value1.and(value2));
        } else if (op == '|') {
            this.valueStack.push(value1.or(value2));
        } else {
            throw new IllegalStateException("Invalid groupExpr: " + this.expression);
        }
    }

    protected Group<String> getResult() {
        while (!this.opStack.isEmpty()) {
            char op = this.opStack.pop().charValue();
            this.updateValueStack(op);
        }
        return this.valueStack.pop();
    }
}

