/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.group;

import cn.zhxu.bs.IllegalParamException;
import cn.zhxu.bs.group.DefaultParserFactory;
import cn.zhxu.bs.group.ExprParser;
import cn.zhxu.bs.group.Group;
import cn.zhxu.bs.group.GroupResolver;
import cn.zhxu.bs.util.Cache;
import cn.zhxu.bs.util.LRUCache;
import cn.zhxu.bs.util.StringUtils;
import java.util.Objects;

public class DefaultGroupResolver
implements GroupResolver {
    static final Group<String> DEFAULT_RAW_GROUP = new Group(3);
    private Cache<Group<String>> cache = new LRUCache<Group<String>>(50);
    private boolean enabled = true;
    private int maxExprLength = 50;
    private ExprParser.Factory parserFactory = new DefaultParserFactory();

    @Override
    public Group<String> resolve(String gExpr) throws IllegalParamException {
        if (StringUtils.isBlank(gExpr)) {
            return DEFAULT_RAW_GROUP;
        }
        if (gExpr.length() > this.maxExprLength) {
            throw new IllegalParamException("The groupExpr is too long: " + gExpr.length() + ", max allowed " + this.maxExprLength);
        }
        if (this.enabled) {
            Group<String> group = this.cache.get(gExpr);
            if (group == null) {
                group = this.doResolve(gExpr);
                this.cache.cache(gExpr, group);
            }
            return group;
        }
        return DEFAULT_RAW_GROUP;
    }

    protected Group<String> doResolve(String expr) throws IllegalParamException {
        try {
            return this.parserFactory.create(expr).parse();
        }
        catch (Exception e) {
            throw new IllegalParamException(e.getMessage(), e);
        }
    }

    @Override
    public ExprParser.Factory getParserFactory() {
        return this.parserFactory;
    }

    public void setParserFactory(ExprParser.Factory parserFactory) {
        this.parserFactory = Objects.requireNonNull(parserFactory);
    }

    public Cache<Group<String>> getCache() {
        return this.cache;
    }

    public void setCache(Cache<Group<String>> cache) {
        this.cache = Objects.requireNonNull(cache);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getMaxExprLength() {
        return this.maxExprLength;
    }

    public void setMaxExprLength(int maxExprLength) {
        this.maxExprLength = maxExprLength;
    }
}

