/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.util;

import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.operator.SqlCond;
import cn.zhxu.bs.param.FieldParam;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import cn.zhxu.bs.util.OrBuilder;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public class Builder<B extends Builder<B>> {
    public static final String ROOT_GROUP = "$";
    protected final Map<String, Object> map;
    protected String group = "$";
    private FieldParam fieldParam = null;
    static final Pattern GROUP_PATTERN = Pattern.compile("_[0-9]+");

    public Builder(Map<String, Object> map) {
        this.map = map;
    }

    public <T> B field(FieldFns.FieldFn<T, ?> fieldFn, Collection<?> values) {
        if (values != null) {
            return this.field(fieldFn, values.toArray());
        }
        return this.field(fieldFn, new FieldFns.FieldFn[0]);
    }

    public <T> B field(FieldFns.FieldFn<T, ?> fieldFn, Object ... values) {
        return this.field(FieldFns.name(fieldFn), values);
    }

    public B field(String fieldName, Collection<?> values) {
        if (values != null) {
            return this.field(fieldName, values.toArray());
        }
        return this.field(fieldName, new Object[0]);
    }

    public B field(String fieldName, Object ... values) {
        if (fieldName != null) {
            if (values.length == 1 && values[0] != null) {
                Object value = values[0];
                if (value instanceof Collection) {
                    return this.field(fieldName, (Collection)value);
                }
                if (value instanceof Object[]) {
                    return this.field(fieldName, (Object[])value);
                }
                if (value.getClass().isArray()) {
                    return this.field(fieldName, Builder.toObjects(value));
                }
            }
            ArrayList<FieldParam.Value> pValues = new ArrayList<FieldParam.Value>();
            for (int index = 0; index < values.length; ++index) {
                pValues.add(new FieldParam.Value(values[index], index));
            }
            String field = fieldName.trim();
            this.fieldParam = new FieldParam(field, pValues);
            if (this.group != null) {
                this.map.put(this.group + MapBuilder.FIELD_PARAM + field, this.fieldParam);
            }
            if (ROOT_GROUP.equals(this.group)) {
                this.map.put(MapBuilder.FIELD_PARAM + field, this.fieldParam);
            }
        }
        return (B)this;
    }

    private static Object[] toObjects(Object arr) {
        int len = Array.getLength(arr);
        Object[] obs = new Object[len];
        for (int i = 0; i < len; ++i) {
            obs[i] = Array.get(arr, i);
        }
        return obs;
    }

    @SafeVarargs
    public final <T> B field(FieldFns.FieldFn<T, ?> fieldFn, FieldFns.FieldFn<T, ?> ... fieldFns) {
        return this.field(FieldFns.name(fieldFn), (Object[])this.toFields(fieldFns));
    }

    public B op(String operator) {
        return this.fieldOp(operator);
    }

    public B op(Class<? extends FieldOp> operator) {
        return this.fieldOp(operator);
    }

    public B op(FieldOp operator) {
        return this.fieldOp(operator);
    }

    private B fieldOp(Object operator) {
        if (this.fieldParam == null) {
            throw new IllegalStateException("The method op(...) must go after field(...) method.");
        }
        this.fieldParam.setOperator(operator);
        return (B)this;
    }

    public B ic() {
        return this.ic(true);
    }

    public B ic(boolean ignoreCase) {
        if (this.fieldParam == null) {
            throw new IllegalStateException("The method ic(...) must go after field(...) method.");
        }
        this.fieldParam.setIgnoreCase(ignoreCase);
        return (B)this;
    }

    public B sql(String sqlCond) {
        return this.fieldOp(new SqlCond(sqlCond));
    }

    public B sql(String sqlCond, Object ... args) {
        return this.fieldOp(new SqlCond(sqlCond, args));
    }

    protected B withOr(Consumer<OrBuilder> condition, String parentExpr) {
        if (this instanceof OrBuilder) {
            throw new IllegalStateException("The method or(...) can't be invoked inner the condition of or(...) method.");
        }
        OrBuilder builder = new OrBuilder(parentExpr, this.group);
        condition.accept(builder);
        String expr1 = builder.getGroupExpr();
        if (expr1 != null && !builder.map.isEmpty()) {
            String expr0 = this.getGroupExpr();
            if (expr0 != null) {
                this.setGroupExpr('(' + expr0 + ')' + '&' + '(' + expr1 + ')');
            } else {
                this.setGroupExpr(expr1);
            }
        }
        this.map.putAll(builder.map);
        return (B)this;
    }

    protected String nextGroup(String group) {
        String next = this.genNextGroup(group);
        while (this.isGroupExists(next)) {
            next = this.genNextGroup(next);
        }
        return next;
    }

    protected String genNextGroup(String group) {
        if (GROUP_PATTERN.matcher(group).matches()) {
            int idx = Integer.parseInt(group.substring(1));
            return "_" + (idx + 1);
        }
        return "_0";
    }

    protected boolean isGroupExists(String group) {
        String expr = this.getGroupExpr();
        return expr != null && expr.contains(group);
    }

    protected String getGroupExpr() {
        Object value = this.map.get(MapBuilder.GROUP_EXPR);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    protected void setGroupExpr(String gExpr) {
        this.map.put(MapBuilder.GROUP_EXPR, gExpr);
    }

    @SafeVarargs
    protected final <T> String[] toFields(FieldFns.FieldFn<T, ?> ... fieldFns) {
        String[] fields = new String[fieldFns.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = FieldFns.name(fieldFns[i]);
        }
        return fields;
    }

    protected <T> List<T> obtainList(String key) {
        return MapUtils.obtainList(this.map, key);
    }
}

