/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.service.service.impl;

import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.model.request.DecisionConfigRequest;
import com.aizuda.snailjob.model.response.base.JobBatchResponse;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.service.convert.JobBatchResponseConverter;
import com.aizuda.snailjob.server.service.service.JobBatchService;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowNode;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractJobBatchService
implements JobBatchService {
    @Autowired
    protected JobTaskBatchMapper jobTaskBatchMapper;
    @Autowired
    protected JobMapper jobMapper;
    @Autowired
    protected WorkflowNodeMapper workflowNodeMapper;

    @Override
    public <T extends JobBatchResponse> T getJobBatchById(Long jobBatchId, Class<T> clazz) {
        JobBatchResponse jobBatchResponse;
        JobTaskBatch jobTaskBatch = (JobTaskBatch)this.jobTaskBatchMapper.selectById((Serializable)jobBatchId);
        if (Objects.isNull(jobTaskBatch)) {
            return null;
        }
        Job job = (Job)this.jobMapper.selectById((Serializable)jobTaskBatch.getJobId());
        try {
            jobBatchResponse = (JobBatchResponse)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            JobBatchResponseConverter.INSTANCE.fillCommonFields(jobTaskBatch, job, jobBatchResponse);
        }
        catch (Exception e) {
            throw new SnailJobServerException("getJobBatchById is error", new Object[]{e});
        }
        if (jobTaskBatch.getSystemTaskType().equals(SyetemTaskTypeEnum.WORKFLOW.getType())) {
            WorkflowNode workflowNode = (WorkflowNode)this.workflowNodeMapper.selectById((Serializable)jobTaskBatch.getWorkflowNodeId());
            jobBatchResponse.setNodeName(workflowNode.getNodeName());
            if (SystemConstants.DECISION_JOB_ID.equals(jobTaskBatch.getJobId())) {
                jobBatchResponse.setDecision((DecisionConfigRequest)JsonUtil.parseObject((String)workflowNode.getNodeInfo(), DecisionConfigRequest.class));
                jobBatchResponse.setExecutionAt(jobTaskBatch.getCreateDt());
                return (T)jobBatchResponse;
            }
        }
        return (T)jobBatchResponse;
    }
}

