/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.listener;

import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.enums.WebSocketSceneEnum;
import com.aizuda.snailjob.server.web.model.event.WsRequestEvent;
import com.aizuda.snailjob.server.web.model.request.JobLogQueryVO;
import com.aizuda.snailjob.server.web.model.request.RetryTaskLogMessageQueryVO;
import com.aizuda.snailjob.server.web.service.JobLogService;
import com.aizuda.snailjob.server.web.service.RetryTaskService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class WsRequestListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WsRequestListener.class);
    private final JobLogService jobLogService;
    private final RetryTaskService retryTaskService;

    @Async(value="logQueryExecutor")
    @EventListener(classes={WsRequestEvent.class})
    public void getJobLogs(WsRequestEvent requestVO) {
        if (!WebSocketSceneEnum.JOB_LOG_SCENE.equals((Object)requestVO.getSceneEnum())) {
            return;
        }
        log.info("getJobLogs {}", (Object)requestVO.getSid());
        String message = requestVO.getMessage();
        JobLogQueryVO jobLogQueryVO = (JobLogQueryVO)((Object)JsonUtil.parseObject((String)message, JobLogQueryVO.class));
        jobLogQueryVO.setSid(requestVO.getSid());
        jobLogQueryVO.setStartRealTime(0L);
        try {
            this.jobLogService.getJobLogPage(jobLogQueryVO);
        }
        catch (Exception e) {
            log.warn("send log error", (Throwable)e);
        }
    }

    @Async(value="logQueryExecutor")
    @EventListener(classes={WsRequestEvent.class})
    public void getRetryLogs(WsRequestEvent requestVO) {
        if (!WebSocketSceneEnum.RETRY_LOG_SCENE.equals((Object)requestVO.getSceneEnum())) {
            return;
        }
        log.info("getRetryLogs {}", (Object)requestVO.getSid());
        String message = requestVO.getMessage();
        RetryTaskLogMessageQueryVO retryTaskLogMessageQueryVO = (RetryTaskLogMessageQueryVO)((Object)JsonUtil.parseObject((String)message, RetryTaskLogMessageQueryVO.class));
        retryTaskLogMessageQueryVO.setSid(requestVO.getSid());
        retryTaskLogMessageQueryVO.setStartRealTime(0L);
        try {
            this.retryTaskService.getRetryTaskLogMessagePage(retryTaskLogMessageQueryVO);
        }
        catch (Exception e) {
            log.warn("send log error", (Throwable)e);
        }
    }

    @Generated
    public WsRequestListener(JobLogService jobLogService, RetryTaskService retryTaskService) {
        this.jobLogService = jobLogService;
        this.retryTaskService = retryTaskService;
    }
}

