/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util;

import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;

public class UUID {
    private boolean noCase;
    private String instanceId;
    private AtomicInteger counter;

    public UUID() {
        this(true);
    }

    public UUID(boolean noCase) {
        byte[] machineId = UUID.getLocalHostAddress();
        byte[] jvmId = this.getRandomizedTime();
        this.instanceId = StringUtil.bytesToString(machineId, noCase) + "-" + StringUtil.bytesToString(jvmId, noCase);
        this.counter = new AtomicInteger();
        this.noCase = noCase;
    }

    private static byte[] getLocalHostAddress() {
        byte[] addr;
        Method getHardwareAddress;
        try {
            getHardwareAddress = NetworkInterface.class.getMethod("getHardwareAddress", new Class[0]);
        }
        catch (Exception e) {
            getHardwareAddress = null;
        }
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            addr = getHardwareAddress != null ? (byte[])getHardwareAddress.invoke((Object)NetworkInterface.getByInetAddress(localHost), new Object[0]) : localHost.getAddress();
        }
        catch (Exception e) {
            addr = null;
        }
        if (addr == null) {
            addr = new byte[]{127, 0, 0, 1};
        }
        return addr;
    }

    private byte[] getRandomizedTime() {
        long jvmId = System.currentTimeMillis();
        long random = new SecureRandom().nextLong();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeLong(jvmId);
            dos.writeLong(random);
        }
        catch (Exception e) {
            // empty catch block
        }
        return baos.toByteArray().toByteArray();
    }

    public String nextID() {
        return this.instanceId + "-" + StringUtil.longToString(System.currentTimeMillis(), this.noCase) + "-" + StringUtil.longToString(this.counter.getAndIncrement(), this.noCase);
    }
}

