/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.i18n.provider;

import com.alibaba.citrus.util.i18n.CharConverter;
import com.alibaba.citrus.util.i18n.CharConverterProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public abstract class ChineseCharConverterProvider
implements CharConverterProvider {
    public static final String CODE_TABLE_CHARSET = "UTF-16BE";
    private char[] codeTable;

    public CharConverter createCharConverter() {
        this.loadCodeTable();
        return new CharConverter(){

            public char convert(char ch) {
                return ChineseCharConverterProvider.this.codeTable[ch];
            }
        };
    }

    protected final char[] loadCodeTable() {
        if (this.codeTable == null) {
            InputStream istream = this.getClass().getResourceAsStream(this.getCodeTableName() + ".ctable");
            if (istream == null) {
                throw new RuntimeException("Could not find code table: " + this.getCodeTableName());
            }
            Reader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(istream, CODE_TABLE_CHARSET));
                this.codeTable = new char[65536];
                for (int i = 0; i < 65536; ++i) {
                    this.codeTable[i] = (char)reader.read();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read code table: " + this.getCodeTableName(), e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return this.codeTable;
    }

    protected abstract String getCodeTableName();
}

