/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.hive.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableExchangePartition;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.hive.ast.HiveAddJarStatement;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInsert;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInsertStatement;
import com.alibaba.druid.sql.dialect.hive.ast.HiveMultiInsertStatement;
import com.alibaba.druid.sql.dialect.hive.stmt.HiveCreateFunctionStatement;
import com.alibaba.druid.sql.dialect.hive.stmt.HiveLoadDataStatement;
import com.alibaba.druid.sql.dialect.hive.stmt.HiveMsckRepairStatement;
import com.alibaba.druid.sql.dialect.hive.visitor.HiveASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.List;

public class HiveOutputVisitor
extends SQLASTOutputVisitor
implements HiveASTVisitor {
    public HiveOutputVisitor(StringBuilder appender) {
        super(appender, DbType.hive);
        this.quote = (char)96;
    }

    public HiveOutputVisitor(StringBuilder appender, DbType dbType) {
        super(appender, dbType);
        this.quote = (char)96;
    }

    public HiveOutputVisitor(StringBuilder appender, boolean parameterized) {
        super(appender, parameterized);
        this.quote = (char)96;
        this.dbType = DbType.hive;
    }

    @Override
    public boolean visit(HiveInsert x) {
        List<SQLAssignItem> partitions;
        SQLExprTableSource tableSource;
        if (x.hasBeforeComment()) {
            this.printlnComments(x.getBeforeCommentsDirect());
        }
        if (x.getInsertBeforeCommentsDirect() != null) {
            this.printlnComments(x.getInsertBeforeCommentsDirect());
        }
        if ((tableSource = x.getTableSource()) != null) {
            if (x.isOverwrite()) {
                this.print0(this.ucase ? "INSERT OVERWRITE TABLE " : "insert overwrite table ");
            } else {
                this.print0(this.ucase ? "INSERT INTO TABLE " : "insert into table ");
            }
            tableSource.accept(this);
        }
        if ((partitions = x.getPartitions()) != null) {
            int partitionsSize = partitions.size();
            if (partitionsSize > 0) {
                this.print0(this.ucase ? " PARTITION (" : " partition (");
                for (int i = 0; i < partitionsSize; ++i) {
                    if (i != 0) {
                        this.print0(", ");
                    }
                    SQLAssignItem assign = partitions.get(i);
                    assign.getTarget().accept(this);
                    if (assign.getValue() == null) continue;
                    this.print('=');
                    assign.getValue().accept(this);
                }
                this.print(')');
            }
            this.println();
        }
        SQLSelect select = x.getQuery();
        List<SQLInsertStatement.ValuesClause> valuesList = x.getValuesList();
        if (select != null) {
            select.accept(this);
        } else if (!valuesList.isEmpty()) {
            this.print0(this.ucase ? "VALUES " : "values ");
            this.printAndAccept(valuesList, ", ");
        }
        return false;
    }

    @Override
    public boolean visit(SQLExternalRecordFormat x) {
        return this.hiveVisit(x);
    }

    @Override
    public boolean visit(HiveMultiInsertStatement x) {
        SQLWithSubqueryClause with = x.getWith();
        if (with != null) {
            this.visit(with);
            this.println();
        }
        SQLTableSource from = x.getFrom();
        if (x.getFrom() != null) {
            if (from instanceof SQLSubqueryTableSource) {
                SQLSelect select = ((SQLSubqueryTableSource)from).getSelect();
                this.print0(this.ucase ? "FROM (" : "from (");
                ++this.indentCount;
                this.println();
                select.accept(this);
                --this.indentCount;
                this.println();
                this.print0(") ");
                String alias = x.getFrom().getAlias();
                if (alias != null) {
                    this.print0(alias);
                }
            } else {
                this.print0(this.ucase ? "FROM " : "from ");
                from.accept(this);
            }
            this.println();
        }
        for (int i = 0; i < x.getItems().size(); ++i) {
            HiveInsert insert = x.getItems().get(i);
            if (i != 0) {
                this.println();
            }
            insert.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(HiveInsertStatement x) {
        List<SQLExpr> columns;
        List<String> insertBeforeComments;
        SQLWithSubqueryClause with;
        if (x.hasBeforeComment()) {
            this.printlnComments(x.getBeforeCommentsDirect());
        }
        if ((with = x.getWith()) != null) {
            this.visit(with);
            this.println();
        }
        if ((insertBeforeComments = x.getInsertBeforeCommentsDirect()) != null) {
            this.printlnComments(insertBeforeComments);
        }
        if (x.isOverwrite()) {
            this.print0(this.ucase ? "INSERT OVERWRITE TABLE " : "insert overwrite table ");
        } else {
            this.print0(this.ucase ? "INSERT INTO TABLE " : "insert into table ");
        }
        x.getTableSource().accept(this);
        List<SQLAssignItem> partitions = x.getPartitions();
        int partitionSize = partitions.size();
        if (partitionSize > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            for (int i = 0; i < partitionSize; ++i) {
                if (i != 0) {
                    this.print0(", ");
                }
                SQLAssignItem assign = partitions.get(i);
                assign.getTarget().accept(this);
                if (assign.getValue() == null) continue;
                this.print('=');
                assign.getValue().accept(this);
            }
            this.print(')');
        }
        if ((columns = x.getColumns()).size() > 0) {
            this.print(" (");
            this.printAndAccept(columns, ", ");
            this.print(')');
        }
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? " IF NOT EXISTS" : " if not exists");
        }
        this.println();
        SQLSelect select = x.getQuery();
        List<SQLInsertStatement.ValuesClause> valuesList = x.getValuesList();
        if (select != null) {
            select.accept(this);
        } else if (!valuesList.isEmpty()) {
            this.print0(this.ucase ? "VALUES " : "values ");
            this.printAndAccept(valuesList, ", ");
        }
        return false;
    }

    @Override
    public boolean visit(SQLMergeStatement.MergeUpdateClause x) {
        this.print0(this.ucase ? "WHEN MATCHED " : "when matched ");
        ++this.indentCount;
        SQLExpr where = x.getWhere();
        if (where != null) {
            ++this.indentCount;
            if (SQLBinaryOpExpr.isAnd(where)) {
                this.println();
            } else {
                this.print(' ');
            }
            this.print0(this.ucase ? "AND " : "and ");
            this.printExpr(where, this.parameterized);
            --this.indentCount;
            this.println();
        }
        this.print0(this.ucase ? "UPDATE SET " : "update set ");
        this.printAndAccept(x.getItems(), ", ");
        --this.indentCount;
        SQLExpr deleteWhere = x.getDeleteWhere();
        if (deleteWhere != null) {
            this.println();
            this.print0(this.ucase ? "WHEN MATCHED AND " : "when matched and ");
            this.printExpr(deleteWhere, this.parameterized);
            this.print0(this.ucase ? " DELETE" : " delete");
        }
        return false;
    }

    @Override
    public boolean visit(HiveCreateFunctionStatement x) {
        SQLExpr symbol;
        String code;
        if (x.isTemporary()) {
            this.print0(this.ucase ? "CREATE TEMPORARY FUNCTION " : "create temporary function ");
        } else {
            this.print0(this.ucase ? "CREATE FUNCTION " : "create function ");
        }
        x.getName().accept(this);
        SQLExpr className = x.getClassName();
        if (className != null) {
            this.print0(this.ucase ? " AS " : " as ");
            className.accept(this);
        }
        ++this.indentCount;
        SQLExpr location = x.getLocation();
        HiveCreateFunctionStatement.ResourceType resourceType = x.getResourceType();
        if (location != null) {
            this.println();
            if (resourceType != null) {
                this.print0(this.ucase ? "USING " : "using ");
                this.print0(resourceType.name());
                this.print(' ');
            } else {
                this.print0(this.ucase ? "LOCATION " : "location ");
            }
            location.accept(this);
        }
        if ((code = x.getCode()) != null) {
            this.println();
            this.print0(this.ucase ? "USING" : "using");
            this.print0(code);
        }
        if ((symbol = x.getSymbol()) != null) {
            this.println();
            this.print0(this.ucase ? "SYMBOL = " : "symbol = ");
            symbol.accept(this);
        }
        --this.indentCount;
        return false;
    }

    @Override
    public boolean visit(HiveLoadDataStatement x) {
        this.print0(this.ucase ? "LOAD DATA " : "load data ");
        if (x.isLocal()) {
            this.print0(this.ucase ? "LOCAL " : "local ");
        }
        this.print0(this.ucase ? "INPATH " : "inpath ");
        x.getInpath().accept(this);
        if (x.isOverwrite()) {
            this.print0(this.ucase ? " OVERWRITE INTO TABLE " : " overwrite into table ");
        } else {
            this.print0(this.ucase ? " INTO TABLE " : " into table ");
        }
        x.getInto().accept(this);
        if (x.getPartition().size() > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(HiveMsckRepairStatement x) {
        SQLExprTableSource table;
        List<SQLCommentHint> headHints = x.getHeadHintsDirect();
        if (headHints != null) {
            for (SQLCommentHint hint : headHints) {
                hint.accept(this);
                this.println();
            }
        }
        this.print0(this.ucase ? "MSCK REPAIR" : "msck repair");
        SQLName database = x.getDatabase();
        if (database != null) {
            this.print0(this.ucase ? " DATABASE " : " database ");
            database.accept(this);
        }
        if ((table = x.getTable()) != null) {
            this.print0(this.ucase ? " TABLE " : " table ");
            table.accept(this);
        }
        if (x.isAddPartitions()) {
            this.print0(this.ucase ? " ADD PARTITIONS" : " add partitions");
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableExchangePartition x) {
        this.print0(this.ucase ? "EXCHANGE PARTITION (" : "exchange partition (");
        this.printAndAccept(x.getPartitions(), ", ");
        this.print0(this.ucase ? ") WITH TABLE " : ") with table ");
        x.getTable().accept(this);
        Boolean validation = x.getValidation();
        if (validation != null) {
            if (validation.booleanValue()) {
                this.print0(this.ucase ? " WITH VALIDATION" : " with validation");
            } else {
                this.print0(this.ucase ? " WITHOUT VALIDATION" : " without validation");
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLCreateIndexStatement x) {
        SQLName storedAs;
        SQLExternalRecordFormat format;
        SQLTableSource in;
        SQLExpr comment;
        String using;
        this.print0(this.ucase ? "CREATE " : "create ");
        this.print0(this.ucase ? "INDEX " : "index ");
        x.getName().accept(this);
        this.print0(this.ucase ? " ON TABLE " : " on table ");
        x.getTable().accept(this);
        this.print0(" (");
        this.printAndAccept(x.getItems(), ", ");
        this.print(')');
        String type = x.getType();
        if (type != null) {
            this.print0(this.ucase ? " AS " : " as ");
            this.print0(type);
        }
        if (x.isDeferedRebuild()) {
            this.print0(this.ucase ? " WITH DEFERRED REBUILD" : " with deferred rebuild");
        }
        if (x.getProperties().size() > 0) {
            this.print0(this.ucase ? " IDXPROPERTIES (" : " idxproperties (");
            this.printAndAccept(x.getProperties(), ", ");
            this.print(')');
        }
        if ((using = x.getUsing()) != null) {
            this.print0(this.ucase ? " USING " : " using ");
            this.print0(using);
        }
        if ((comment = x.getComment()) != null) {
            this.print0(this.ucase ? " COMMENT " : " comment ");
            comment.accept(this);
        }
        if ((in = x.getIn()) != null) {
            this.print0(this.ucase ? " IN TABLE " : " in table ");
            in.accept(this);
        }
        if ((format = x.getRowFormat()) != null) {
            this.println();
            this.print0(this.ucase ? "ROW FORMAT DELIMITED " : "row rowFormat delimited ");
            this.visit(format);
        }
        if ((storedAs = x.getStoredAs()) != null) {
            this.print0(this.ucase ? " STORED BY " : " stored by ");
            storedAs.accept(this);
        }
        if (x.getTableProperties().size() > 0) {
            this.print0(this.ucase ? " TBLPROPERTIES (" : " tblproperties (");
            this.printAndAccept(x.getTableProperties(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLCharExpr x, boolean parameterized) {
        String text = x.getText();
        if (text == null) {
            this.print0(this.ucase ? "NULL" : "null");
        } else {
            StringBuilder buf = new StringBuilder(text.length() + 2);
            buf.append('\'');
            block9: for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                switch (ch) {
                    case '\\': {
                        buf.append("\\\\");
                        continue block9;
                    }
                    case '\'': {
                        buf.append("\\'");
                        continue block9;
                    }
                    case '\u0000': {
                        buf.append("\\0");
                        continue block9;
                    }
                    case '\n': {
                        buf.append("\\n");
                        continue block9;
                    }
                    case '\r': {
                        buf.append("\\r");
                        continue block9;
                    }
                    case '\b': {
                        buf.append("\\b");
                        continue block9;
                    }
                    case '\t': {
                        buf.append("\\t");
                        continue block9;
                    }
                    default: {
                        if (ch == '\u2605') {
                            buf.append("\\u2605");
                            continue block9;
                        }
                        if (ch == '\u25bc') {
                            buf.append("\\u25bc");
                            continue block9;
                        }
                        buf.append(ch);
                    }
                }
            }
            buf.append('\'');
            this.print0(buf.toString());
        }
        return false;
    }

    @Override
    public boolean visit(HiveAddJarStatement x) {
        this.print0(this.ucase ? "ADD JAR " : "add jar ");
        this.print0(x.getPath());
        return false;
    }
}

