/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.spring.util;

import com.alibaba.spring.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class BeanFactoryUtils {
    public static <T> T getOptionalBean(ListableBeanFactory beanFactory, String beanName, Class<T> beanType) {
        if (!StringUtils.hasText((String)beanName)) {
            return null;
        }
        String[] beanNames = ObjectUtils.of(beanName);
        List<T> beans = BeanFactoryUtils.getBeans(beanFactory, beanNames, beanType);
        return CollectionUtils.isEmpty(beans) ? null : (T)beans.get(0);
    }

    public static <T> List<T> getBeans(ListableBeanFactory beanFactory, String[] beanNames, Class<T> beanType) {
        if (org.springframework.util.ObjectUtils.isEmpty((Object[])beanNames)) {
            return Collections.emptyList();
        }
        Object[] allBeanNames = org.springframework.beans.factory.BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, beanType);
        ArrayList<Object> beans = new ArrayList<Object>(beanNames.length);
        for (String beanName : beanNames) {
            if (!org.springframework.util.ObjectUtils.containsElement((Object[])allBeanNames, (Object)beanName)) continue;
            beans.add(beanFactory.getBean(beanName, beanType));
        }
        return Collections.unmodifiableList(beans);
    }
}

