/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.alibaba.ttl.TtlEnhanced;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TtlCallable<V>
implements Callable<V>,
TtlEnhanced {
    private final AtomicReference<Object> capturedRef = new AtomicReference<Object>(TransmittableThreadLocal.Transmitter.capture());
    private final Callable<V> callable;
    private final boolean releaseTtlValueReferenceAfterCall;

    private TtlCallable(@Nonnull Callable<V> callable, boolean releaseTtlValueReferenceAfterCall) {
        this.callable = callable;
        this.releaseTtlValueReferenceAfterCall = releaseTtlValueReferenceAfterCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V call() throws Exception {
        Object captured = this.capturedRef.get();
        if (captured == null || this.releaseTtlValueReferenceAfterCall && !this.capturedRef.compareAndSet(captured, null)) {
            throw new IllegalStateException("TTL value reference is released after call!");
        }
        Object backup = TransmittableThreadLocal.Transmitter.replay(captured);
        try {
            V v = this.callable.call();
            return v;
        }
        finally {
            TransmittableThreadLocal.Transmitter.restore(backup);
        }
    }

    @Nonnull
    public Callable<V> getCallable() {
        return this.callable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TtlCallable that = (TtlCallable)o;
        return this.callable.equals(that.callable);
    }

    public int hashCode() {
        return this.callable.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + " - " + this.callable.toString();
    }

    public static <T> TtlCallable<T> get(Callable<T> callable) {
        return TtlCallable.get(callable, false);
    }

    @Nullable
    public static <T> TtlCallable<T> get(@Nullable Callable<T> callable, boolean releaseTtlValueReferenceAfterCall) {
        return TtlCallable.get(callable, releaseTtlValueReferenceAfterCall, false);
    }

    @Nullable
    public static <T> TtlCallable<T> get(@Nullable Callable<T> callable, boolean releaseTtlValueReferenceAfterCall, boolean idempotent) {
        if (null == callable) {
            return null;
        }
        if (callable instanceof TtlEnhanced) {
            if (idempotent) {
                return (TtlCallable)callable;
            }
            throw new IllegalStateException("Already TtlCallable!");
        }
        return new TtlCallable<T>(callable, releaseTtlValueReferenceAfterCall);
    }

    @Nonnull
    public static <T> List<TtlCallable<T>> gets(@Nullable Collection<? extends Callable<T>> tasks) {
        return TtlCallable.gets(tasks, false, false);
    }

    @Nonnull
    public static <T> List<TtlCallable<T>> gets(@Nullable Collection<? extends Callable<T>> tasks, boolean releaseTtlValueReferenceAfterCall) {
        return TtlCallable.gets(tasks, releaseTtlValueReferenceAfterCall, false);
    }

    @Nonnull
    public static <T> List<TtlCallable<T>> gets(@Nullable Collection<? extends Callable<T>> tasks, boolean releaseTtlValueReferenceAfterCall, boolean idempotent) {
        if (null == tasks) {
            return Collections.emptyList();
        }
        ArrayList<TtlCallable<T>> copy = new ArrayList<TtlCallable<T>>();
        for (Callable<T> task : tasks) {
            copy.add(TtlCallable.get(task, releaseTtlValueReferenceAfterCall, idempotent));
        }
        return copy;
    }

    @Nullable
    public static <T> Callable<T> unwrap(@Nullable Callable<T> callable) {
        if (!(callable instanceof TtlCallable)) {
            return callable;
        }
        return ((TtlCallable)callable).getCallable();
    }

    @Nonnull
    public static <T> List<Callable<T>> unwraps(@Nullable Collection<? extends Callable<T>> tasks) {
        if (null == tasks) {
            return Collections.emptyList();
        }
        ArrayList<Callable<T>> copy = new ArrayList<Callable<T>>();
        for (Callable<T> task : tasks) {
            if (!(task instanceof TtlCallable)) {
                copy.add(task);
                continue;
            }
            copy.add(((TtlCallable)task).getCallable());
        }
        return copy;
    }
}

