/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool;

import com.alibaba.ttl.TtlCallable;
import com.alibaba.ttl.TtlEnhanced;
import com.alibaba.ttl.TtlRunnable;
import com.alibaba.ttl.threadpool.ExecutorServiceTtlWrapper;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

class ScheduledExecutorServiceTtlWrapper
extends ExecutorServiceTtlWrapper
implements ScheduledExecutorService,
TtlEnhanced {
    final ScheduledExecutorService scheduledExecutorService;

    public ScheduledExecutorServiceTtlWrapper(@Nonnull ScheduledExecutorService scheduledExecutorService) {
        super(scheduledExecutorService);
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    @Nonnull
    public ScheduledFuture<?> schedule(@Nonnull Runnable command, long delay, @Nonnull TimeUnit unit) {
        return this.scheduledExecutorService.schedule(TtlRunnable.get(command), delay, unit);
    }

    @Override
    @Nonnull
    public <V> ScheduledFuture<V> schedule(@Nonnull Callable<V> callable, long delay, @Nonnull TimeUnit unit) {
        return this.scheduledExecutorService.schedule(TtlCallable.get(callable), delay, unit);
    }

    @Override
    @Nonnull
    public ScheduledFuture<?> scheduleAtFixedRate(@Nonnull Runnable command, long initialDelay, long period, @Nonnull TimeUnit unit) {
        return this.scheduledExecutorService.scheduleAtFixedRate(TtlRunnable.get(command), initialDelay, period, unit);
    }

    @Override
    @Nonnull
    public ScheduledFuture<?> scheduleWithFixedDelay(@Nonnull Runnable command, long initialDelay, long delay, @Nonnull TimeUnit unit) {
        return this.scheduledExecutorService.scheduleWithFixedDelay(TtlRunnable.get(command), initialDelay, delay, unit);
    }

    @Override
    @Nonnull
    public ScheduledExecutorService unwrap() {
        return this.scheduledExecutorService;
    }
}

