/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.exception;

public enum AmqpResponseCode {
    ACCEPTED(202),
    OK(200),
    BAD_REQUEST(400),
    NOT_FOUND(404),
    FORBIDDEN(403),
    INTERNAL_SERVER_ERROR(500),
    UNAUTHORIZED(401),
    CONTINUE(100),
    SWITCHING_PROTOCOLS(101),
    CREATED(201),
    NON_AUTHORITATIVE_INFORMATION(203),
    NO_CONTENT(204),
    RESET_CONTENT(205),
    PARTIAL_CONTENT(206),
    AMBIGUOUS(300),
    MULTIPLE_CHOICES(300),
    MOVED(301),
    MOVED_PERMANENTLY(301),
    FOUND(302),
    REDIRECT(302),
    REDIRECT_METHOD(303),
    SEE_OTHER(303),
    NOT_MODIFIED(304),
    USE_PROXY(305),
    UNUSED(306),
    REDIRECT_KEEP_VERB(307),
    TEMPORARY_REDIRECT(307),
    PAYMENT_REQUIRED(402),
    METHOD_NOT_ALLOWED(405),
    NOT_ACCEPTABLE(406),
    PROXY_AUTHENTICATION_REQUIRED(407),
    REQUEST_TIMEOUT(408),
    CONFLICT(409),
    GONE(410),
    LENGTH_REQUIRED(411),
    PRECONDITION_FAILED(412),
    REQUEST_ENTITY_TOO_LARGE(413),
    REQUEST_URI_TOO_LONG(414),
    UNSUPPORTED_MEDIA_TYPE(415),
    REQUESTED_RANGE_NOT_SATISFIABLE(416),
    EXPECTATION_FAILED(417),
    UPGRADE_REQUIRED(426),
    NOT_IMPLEMENTED(501),
    BAD_GATEWAY(502),
    SERVICE_UNAVAILABLE(503),
    GATEWAY_TIMEOUT(504),
    HTTP_VERSION_NOT_SUPPORTED(505);

    private static final AmqpResponseCode[] VALUE_MAP;
    private final int value;

    private AmqpResponseCode(int value) {
        this.value = value;
    }

    public static AmqpResponseCode fromValue(int value) {
        if (value >= 0 && value < VALUE_MAP.length) {
            return VALUE_MAP[value];
        }
        return null;
    }

    public int getValue() {
        return this.value;
    }

    static {
        VALUE_MAP = new AmqpResponseCode[1024];
        AmqpResponseCode[] amqpResponseCodeArray = AmqpResponseCode.values();
        int n = amqpResponseCodeArray.length;
        for (int i = 0; i < n; ++i) {
            AmqpResponseCode code;
            AmqpResponseCode.VALUE_MAP[code.value] = code = amqpResponseCodeArray[i];
        }
    }
}

