/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import java.net.InetSocketAddress;
import java.util.Objects;

public class ProxyOptions {
    private final InetSocketAddress address;
    private final Type type;
    private String username;
    private String password;

    public ProxyOptions(Type type, InetSocketAddress address) {
        this.type = type;
        this.address = address;
    }

    public ProxyOptions setCredentials(String username, String password) {
        this.username = Objects.requireNonNull(username, "'username' cannot be null.");
        this.password = Objects.requireNonNull(password, "'password' cannot be null.");
        return this;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public Type getType() {
        return this.type;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public static enum Type {
        HTTP,
        SOCKS4,
        SOCKS5;

    }
}

