/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.annotation.ResumeOperation;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.UnexpectedLengthException;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.EncodedParameter;
import com.azure.core.http.rest.OperationDescription;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.ResponseConstructorsCache;
import com.azure.core.http.rest.SwaggerInterfaceParser;
import com.azure.core.http.rest.SwaggerMethodParser;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.implementation.http.UnexpectedExceptionInformation;
import com.azure.core.implementation.serializer.HttpResponseDecoder;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.core.util.tracing.TracerProxy;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Optional;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;
import reactor.util.context.Context;

public final class RestProxy
implements InvocationHandler {
    private final ClientLogger logger = new ClientLogger(RestProxy.class);
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializer;
    private final SwaggerInterfaceParser interfaceParser;
    private final HttpResponseDecoder decoder;
    private final ResponseConstructorsCache responseConstructorsCache;

    private RestProxy(HttpPipeline httpPipeline, SerializerAdapter serializer, SwaggerInterfaceParser interfaceParser) {
        this.httpPipeline = httpPipeline;
        this.serializer = serializer;
        this.interfaceParser = interfaceParser;
        this.decoder = new HttpResponseDecoder(this.serializer);
        this.responseConstructorsCache = new ResponseConstructorsCache();
    }

    private SwaggerMethodParser getMethodParser(Method method) {
        return this.interfaceParser.getMethodParser(method);
    }

    public Mono<HttpResponse> send(HttpRequest request, com.azure.core.util.Context contextData) {
        return this.httpPipeline.send(request, contextData);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        try {
            if (method.isAnnotationPresent(ResumeOperation.class)) {
                OperationDescription opDesc = CoreUtils.findFirstOfType(args, OperationDescription.class);
                Method resumeMethod = this.determineResumeMethod(method, opDesc.getMethodName());
                SwaggerMethodParser methodParser = this.getMethodParser(resumeMethod);
                HttpRequest request = this.createHttpRequest(opDesc, methodParser, args);
                Type returnType = methodParser.getReturnType();
                return this.handleResumeOperation(request, opDesc, methodParser, returnType, this.startTracingSpan(resumeMethod, com.azure.core.util.Context.NONE));
            }
            SwaggerMethodParser methodParser = this.getMethodParser(method);
            HttpRequest request = this.createHttpRequest(methodParser, args);
            com.azure.core.util.Context context = methodParser.setContext(args).addData("caller-method", methodParser.getFullyQualifiedMethodName());
            context = this.startTracingSpan(method, context);
            if (request.getBody() != null) {
                request.setBody(this.validateLength(request));
            }
            Mono<HttpResponse> asyncResponse = this.send(request, context);
            Mono<HttpResponseDecoder.HttpDecodedResponse> asyncDecodedResponse = this.decoder.decode(asyncResponse, methodParser);
            return this.handleHttpResponse(request, asyncDecodedResponse, methodParser, methodParser.getReturnType(), context);
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)e));
        }
    }

    private Flux<ByteBuffer> validateLength(HttpRequest request) {
        Flux<ByteBuffer> bbFlux = request.getBody();
        if (bbFlux == null) {
            return Flux.empty();
        }
        return Flux.defer(() -> {
            Long expectedLength = Long.valueOf(request.getHeaders().getValue("Content-Length"));
            long[] currentTotalLength = new long[1];
            return bbFlux.doOnEach(s -> {
                if (s.isOnNext()) {
                    ByteBuffer byteBuffer = (ByteBuffer)s.get();
                    int currentLength = byteBuffer == null ? 0 : byteBuffer.remaining();
                    currentTotalLength[0] = currentTotalLength[0] + (long)currentLength;
                    if (currentTotalLength[0] > expectedLength) {
                        throw this.logger.logExceptionAsError(new UnexpectedLengthException(String.format("Request body emitted %d bytes more than the expected %d bytes.", currentTotalLength[0], expectedLength), currentTotalLength[0], expectedLength));
                    }
                } else if (s.isOnComplete() && expectedLength.compareTo(currentTotalLength[0]) != 0) {
                    throw this.logger.logExceptionAsError(new UnexpectedLengthException(String.format("Request body emitted %d bytes less than the expected %d bytes.", currentTotalLength[0], expectedLength), currentTotalLength[0], expectedLength));
                }
            });
        });
    }

    private Method determineResumeMethod(Method method, String resumeMethodName) {
        for (Method potentialResumeMethod : method.getDeclaringClass().getMethods()) {
            if (!potentialResumeMethod.getName().equals(resumeMethodName)) continue;
            return potentialResumeMethod;
        }
        return null;
    }

    private com.azure.core.util.Context startTracingSpan(Method method, com.azure.core.util.Context context) {
        String spanName = String.format("%s.%s", this.interfaceParser.getServiceName(), method.getName());
        context = TracerProxy.setSpanName(spanName, context);
        return TracerProxy.start(spanName, context);
    }

    private HttpRequest createHttpRequest(SwaggerMethodParser methodParser, Object[] args) throws IOException {
        UrlBuilder urlBuilder;
        String path = methodParser.setPath(args);
        UrlBuilder pathUrlBuilder = UrlBuilder.parse(path);
        if (pathUrlBuilder.getScheme() != null) {
            urlBuilder = pathUrlBuilder;
        } else {
            urlBuilder = new UrlBuilder();
            String scheme = methodParser.setScheme(args);
            urlBuilder.setScheme(scheme);
            String host = methodParser.setHost(args);
            urlBuilder.setHost(host);
            if (path != null && !path.isEmpty() && !path.equals("/")) {
                String hostPath = urlBuilder.getPath();
                if (hostPath == null || hostPath.isEmpty() || hostPath.equals("/") || path.contains("://")) {
                    urlBuilder.setPath(path);
                } else {
                    urlBuilder.setPath(hostPath + "/" + path);
                }
            }
        }
        for (EncodedParameter queryParameter : methodParser.setEncodedQueryParameters(args)) {
            urlBuilder.setQueryParameter(queryParameter.getName(), queryParameter.getEncodedValue());
        }
        URL url = urlBuilder.toUrl();
        HttpRequest request = this.configRequest(new HttpRequest(methodParser.getHttpMethod(), url), methodParser, args);
        for (HttpHeader header : methodParser.setHeaders(args)) {
            request.setHeader(header.getName(), header.getValue());
        }
        return request;
    }

    private HttpRequest createHttpRequest(OperationDescription operationDescription, SwaggerMethodParser methodParser, Object[] args) throws IOException {
        HttpRequest request = this.configRequest(new HttpRequest(methodParser.getHttpMethod(), operationDescription.getUrl()), methodParser, args);
        for (String headerName : operationDescription.getHeaders().keySet()) {
            request.setHeader(headerName, operationDescription.getHeaders().get(headerName));
        }
        return request;
    }

    private HttpRequest configRequest(HttpRequest request, SwaggerMethodParser methodParser, Object[] args) throws IOException {
        Object bodyContentObject = methodParser.setBody(args);
        if (bodyContentObject == null) {
            request.getHeaders().put("Content-Length", "0");
        } else {
            String bodyContentString;
            String[] contentTypeParts;
            String contentType = methodParser.getBodyContentType();
            if (contentType == null || contentType.isEmpty()) {
                contentType = bodyContentObject instanceof byte[] || bodyContentObject instanceof String ? "application/octet-stream" : "application/json";
            }
            request.getHeaders().put("Content-Type", contentType);
            boolean isJson = false;
            for (String contentTypePart : contentTypeParts = contentType.split(";")) {
                if (!contentTypePart.trim().equalsIgnoreCase("application/json")) continue;
                isJson = true;
                break;
            }
            if (isJson) {
                bodyContentString = this.serializer.serialize(bodyContentObject, SerializerEncoding.JSON);
                request.setBody(bodyContentString);
            } else if (FluxUtil.isFluxByteBuffer(methodParser.getBodyJavaType())) {
                request.setBody((Flux<ByteBuffer>)((Flux)bodyContentObject));
            } else if (bodyContentObject instanceof byte[]) {
                request.setBody((byte[])bodyContentObject);
            } else if (bodyContentObject instanceof String) {
                bodyContentString = (String)bodyContentObject;
                if (!bodyContentString.isEmpty()) {
                    request.setBody(bodyContentString);
                }
            } else if (bodyContentObject instanceof ByteBuffer) {
                request.setBody((Flux<ByteBuffer>)Flux.just((Object)((ByteBuffer)bodyContentObject)));
            } else {
                bodyContentString = this.serializer.serialize(bodyContentObject, SerializerEncoding.fromHeaders(request.getHeaders()));
                request.setBody(bodyContentString);
            }
        }
        return request;
    }

    private Mono<HttpResponseDecoder.HttpDecodedResponse> ensureExpectedStatus(Mono<HttpResponseDecoder.HttpDecodedResponse> asyncDecodedResponse, SwaggerMethodParser methodParser) {
        return asyncDecodedResponse.flatMap(decodedHttpResponse -> this.ensureExpectedStatus((HttpResponseDecoder.HttpDecodedResponse)decodedHttpResponse, methodParser, null));
    }

    private static Exception instantiateUnexpectedException(UnexpectedExceptionInformation exception, HttpResponse httpResponse, String responseContent, Object responseDecodedContent) {
        Exception result;
        int responseStatusCode = httpResponse.getStatusCode();
        String contentType = httpResponse.getHeaderValue("Content-Type");
        String bodyRepresentation = "application/octet-stream".equalsIgnoreCase(contentType) ? "(" + httpResponse.getHeaderValue("Content-Length") + "-byte body)" : (responseContent.isEmpty() ? "(empty body)" : "\"" + responseContent + "\"");
        try {
            Constructor<? extends HttpResponseException> exceptionConstructor = exception.getExceptionType().getConstructor(String.class, HttpResponse.class, exception.getExceptionBodyType());
            result = exceptionConstructor.newInstance("Status code " + responseStatusCode + ", " + bodyRepresentation, httpResponse, responseDecodedContent);
        }
        catch (ReflectiveOperationException e) {
            String message = "Status code " + responseStatusCode + ", but an instance of " + exception.getExceptionType().getCanonicalName() + " cannot be created. Response body: " + bodyRepresentation;
            result = new IOException(message, e);
        }
        return result;
    }

    private Mono<HttpResponseDecoder.HttpDecodedResponse> ensureExpectedStatus(HttpResponseDecoder.HttpDecodedResponse decodedResponse, SwaggerMethodParser methodParser, int[] additionalAllowedStatusCodes) {
        Mono asyncResult;
        int responseStatusCode = decodedResponse.getSourceResponse().getStatusCode();
        if (!methodParser.isExpectedResponseStatusCode(responseStatusCode, additionalAllowedStatusCodes)) {
            Mono<String> bodyAsString = decodedResponse.getSourceResponse().getBodyAsString();
            asyncResult = bodyAsString.flatMap(responseContent -> {
                Mono<Object> decodedErrorBody = decodedResponse.getDecodedBody();
                return decodedErrorBody.flatMap(responseDecodedErrorObject -> {
                    Exception exception = RestProxy.instantiateUnexpectedException(methodParser.getUnexpectedException(responseStatusCode), decodedResponse.getSourceResponse(), responseContent, responseDecodedErrorObject);
                    return Mono.error((Throwable)exception);
                }).switchIfEmpty(Mono.defer(() -> {
                    Exception exception = RestProxy.instantiateUnexpectedException(methodParser.getUnexpectedException(responseStatusCode), decodedResponse.getSourceResponse(), responseContent, null);
                    return Mono.error((Throwable)exception);
                }));
            }).switchIfEmpty(Mono.defer(() -> {
                Exception exception = RestProxy.instantiateUnexpectedException(methodParser.getUnexpectedException(responseStatusCode), decodedResponse.getSourceResponse(), "", null);
                return Mono.error((Throwable)exception);
            }));
        } else {
            asyncResult = Mono.just((Object)decodedResponse);
        }
        return asyncResult;
    }

    private Mono<?> handleRestResponseReturnType(HttpResponseDecoder.HttpDecodedResponse response, SwaggerMethodParser methodParser, Type entityType) {
        Type bodyType;
        Mono asyncResult = TypeUtil.isTypeOrSubTypeOf(entityType, Response.class) ? (TypeUtil.isTypeOrSubTypeOf(bodyType = TypeUtil.getRestResponseBodyType(entityType), Void.class) ? response.getSourceResponse().getBody().ignoreElements().then(this.createResponse(response, entityType, null)) : this.handleBodyReturnType(response, methodParser, bodyType).flatMap(bodyAsObject -> this.createResponse(response, entityType, bodyAsObject)).switchIfEmpty(Mono.defer(() -> this.createResponse(response, entityType, null)))) : this.handleBodyReturnType(response, methodParser, entityType);
        return asyncResult;
    }

    private Mono<Response<?>> createResponse(HttpResponseDecoder.HttpDecodedResponse response, Type entityType, Object bodyAsObject) {
        Class<Object> cls = TypeUtil.getRawClass(entityType);
        if (cls.equals(Response.class)) {
            cls = ResponseBase.class;
        } else if (cls.equals(PagedResponse.class)) {
            cls = PagedResponseBase.class;
            if (bodyAsObject != null && !TypeUtil.isTypeOrSubTypeOf(bodyAsObject.getClass(), Page.class)) {
                throw this.logger.logExceptionAsError(new RuntimeException("Unable to create PagedResponse<T>. Body must be of a type that implements: " + Page.class));
            }
        }
        Constructor<? extends Response<?>> ctr = this.responseConstructorsCache.get(cls);
        if (ctr != null) {
            return this.responseConstructorsCache.invoke(ctr, response, bodyAsObject);
        }
        return Mono.error((Throwable)new RuntimeException("Cannot find suitable constructor for class " + cls));
    }

    private Mono<?> handleBodyReturnType(HttpResponseDecoder.HttpDecodedResponse response, SwaggerMethodParser methodParser, Type entityType) {
        Mono asyncResult;
        int responseStatusCode = response.getSourceResponse().getStatusCode();
        HttpMethod httpMethod = methodParser.getHttpMethod();
        Type returnValueWireType = methodParser.getReturnValueWireType();
        if (httpMethod == HttpMethod.HEAD && (TypeUtil.isTypeOrSubTypeOf(entityType, Boolean.TYPE) || TypeUtil.isTypeOrSubTypeOf(entityType, Boolean.class))) {
            boolean isSuccess = responseStatusCode / 100 == 2;
            asyncResult = Mono.just((Object)isSuccess);
        } else if (TypeUtil.isTypeOrSubTypeOf(entityType, byte[].class)) {
            Mono responseBodyBytesAsync = response.getSourceResponse().getBodyAsByteArray();
            if (returnValueWireType == Base64Url.class) {
                responseBodyBytesAsync = responseBodyBytesAsync.map(base64UrlBytes -> new Base64Url((byte[])base64UrlBytes).decodedBytes());
            }
            asyncResult = responseBodyBytesAsync;
        } else {
            asyncResult = FluxUtil.isFluxByteBuffer(entityType) ? Mono.just(response.getSourceResponse().getBody()) : response.getDecodedBody();
        }
        return asyncResult;
    }

    private Object handleHttpResponse(HttpRequest httpRequest, Mono<HttpResponseDecoder.HttpDecodedResponse> asyncDecodedHttpResponse, SwaggerMethodParser methodParser, Type returnType, com.azure.core.util.Context context) {
        return this.handleRestReturnType(asyncDecodedHttpResponse, methodParser, returnType, context);
    }

    private Object handleResumeOperation(HttpRequest httpRequest, OperationDescription operationDescription, SwaggerMethodParser methodParser, Type returnType, com.azure.core.util.Context context) {
        throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)new Exception("The resume operation is not available in the base RestProxy class.")));
    }

    private Object handleRestReturnType(Mono<HttpResponseDecoder.HttpDecodedResponse> asyncHttpDecodedResponse, SwaggerMethodParser methodParser, Type returnType, com.azure.core.util.Context context) {
        Object result;
        Mono asyncExpectedResponse = this.ensureExpectedStatus(asyncHttpDecodedResponse, methodParser).doOnEach(RestProxy::endTracingSpan).subscriberContext(Context.of((Object)"TRACING_CONTEXT", (Object)context));
        if (TypeUtil.isTypeOrSubTypeOf(returnType, Mono.class)) {
            Type monoTypeParam = TypeUtil.getTypeArgument(returnType);
            result = TypeUtil.isTypeOrSubTypeOf(monoTypeParam, Void.class) ? asyncExpectedResponse.then() : asyncExpectedResponse.flatMap(response -> this.handleRestResponseReturnType((HttpResponseDecoder.HttpDecodedResponse)response, methodParser, monoTypeParam));
        } else if (FluxUtil.isFluxByteBuffer(returnType)) {
            result = asyncExpectedResponse.flatMapMany(ar -> ar.getSourceResponse().getBody());
        } else if (TypeUtil.isTypeOrSubTypeOf(returnType, Void.TYPE) || TypeUtil.isTypeOrSubTypeOf(returnType, Void.class)) {
            asyncExpectedResponse.block();
            result = null;
        } else {
            result = asyncExpectedResponse.flatMap(httpResponse -> this.handleRestResponseReturnType((HttpResponseDecoder.HttpDecodedResponse)httpResponse, methodParser, returnType)).block();
        }
        return result;
    }

    private static void endTracingSpan(Signal<HttpResponseDecoder.HttpDecodedResponse> signal) {
        if (signal.isOnComplete() || signal.isOnSubscribe()) {
            return;
        }
        Context context = signal.getContext();
        Optional tracingContext = context.getOrEmpty((Object)"TRACING_CONTEXT");
        if (!tracingContext.isPresent()) {
            return;
        }
        int statusCode = 0;
        Throwable throwable = null;
        if (signal.hasValue()) {
            HttpResponseDecoder.HttpDecodedResponse httpDecodedResponse = (HttpResponseDecoder.HttpDecodedResponse)signal.get();
            statusCode = httpDecodedResponse.getSourceResponse().getStatusCode();
        } else if (signal.hasError() && (throwable = signal.getThrowable()) instanceof HttpResponseException) {
            HttpResponseException exception = (HttpResponseException)throwable;
            statusCode = exception.getResponse().getStatusCode();
        }
        TracerProxy.end(statusCode, throwable, (com.azure.core.util.Context)tracingContext.get());
    }

    private static SerializerAdapter createDefaultSerializer() {
        return JacksonAdapter.createDefaultSerializerAdapter();
    }

    private static HttpPipeline createDefaultPipeline() {
        return RestProxy.createDefaultPipeline(null);
    }

    private static HttpPipeline createDefaultPipeline(HttpPipelinePolicy credentialsPolicy) {
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        policies.add(new UserAgentPolicy());
        policies.add(new RetryPolicy());
        policies.add(new CookiePolicy());
        if (credentialsPolicy != null) {
            policies.add(credentialsPolicy);
        }
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).build();
    }

    public static <A> A create(Class<A> swaggerInterface) {
        return RestProxy.create(swaggerInterface, RestProxy.createDefaultPipeline(), RestProxy.createDefaultSerializer());
    }

    public static <A> A create(Class<A> swaggerInterface, HttpPipeline httpPipeline) {
        return RestProxy.create(swaggerInterface, httpPipeline, RestProxy.createDefaultSerializer());
    }

    public static <A> A create(Class<A> swaggerInterface, HttpPipeline httpPipeline, SerializerAdapter serializer) {
        SwaggerInterfaceParser interfaceParser = new SwaggerInterfaceParser(swaggerInterface, serializer);
        RestProxy restProxy = new RestProxy(httpPipeline, serializer, interfaceParser);
        return (A)Proxy.newProxyInstance(swaggerInterface.getClassLoader(), new Class[]{swaggerInterface}, (InvocationHandler)restProxy);
    }
}

