/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer.jsonwrapper.jacksonwrapper;

import com.azure.core.implementation.serializer.jsonwrapper.api.Node;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;

public class JacksonNode
implements Node {
    private final JsonNode node;

    public JacksonNode(JsonNode node) {
        this.node = node;
    }

    @Override
    public Node get(String name) {
        return new JacksonNode(this.node.get(name));
    }

    @Override
    public String asString() {
        return this.node.asText();
    }

    @Override
    public int asInt() {
        return this.node.asInt();
    }

    @Override
    public double asDouble() {
        return this.node.asDouble();
    }

    @Override
    public boolean asBoolean() {
        return this.node.asBoolean();
    }

    @Override
    public boolean isJsonArray() {
        return this.node.isArray();
    }

    @Override
    public boolean isJsonObject() {
        return this.node.isObject();
    }

    @Override
    public boolean isJsonPrimitive() {
        return this.node.isBoolean() || this.node.isDouble() || this.node.isFloat() || this.node.isInt() || this.node.isLong() || this.node.isShort();
    }

    @Override
    public List<Node> getElements() {
        ArrayList<Node> result = new ArrayList<Node>();
        this.node.forEach(jsonNode -> result.add(new JacksonNode((JsonNode)jsonNode)));
        return result;
    }
}

