/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http.rest;

import com.azure.core.implementation.AccessibleByteArrayOutputStream;
import com.azure.core.implementation.ReflectionUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLStreamException;

public final class ReflectionSerializable {
    private static final ClientLogger LOGGER = new ClientLogger(ReflectionSerializable.class);
    private static final Class<?> JSON_SERIALIZABLE;
    private static final Class<?> JSON_READER;
    private static final CreateJsonReader JSON_READER_CREATOR;
    private static final CreateJsonWriter JSON_WRITER_CREATOR;
    private static final JsonWriterWriteJson JSON_WRITER_WRITE_JSON_SERIALIZABLE;
    private static final JsonWriterFlush JSON_WRITER_FLUSH;
    static final boolean JSON_SERIALIZABLE_SUPPORTED;
    private static final Map<Class<?>, MethodHandle> FROM_JSON_CACHE;
    private static final Class<?> XML_SERIALIZABLE;
    private static final Class<?> XML_READER;
    private static final CreateXmlReader XML_READER_CREATOR;
    private static final CreateXmlWriter XML_WRITER_CREATOR;
    private static final XmlWriterWriteStartDocument XML_WRITER_WRITE_XML_START_DOCUMENT;
    private static final XmlWriterWriteXml XML_WRITER_WRITE_XML_SERIALIZABLE;
    private static final XmlWriterFlush XML_WRITER_FLUSH;
    static final boolean XML_SERIALIZABLE_SUPPORTED;
    private static final Map<Class<?>, MethodHandle> FROM_XML_CACHE;

    private static <T> T createMetaFactory(Method method, MethodHandles.Lookup unreflectLookup, Class<T> interfaceType, MethodType interfaceMethodType, MethodHandles.Lookup defaultLookup) throws Throwable {
        MethodHandle handle = unreflectLookup.unreflect(method);
        Method functionalMethod = interfaceType.getDeclaredMethods()[0];
        return (T)LambdaMetafactory.metafactory(defaultLookup, functionalMethod.getName(), MethodType.methodType(interfaceType), interfaceMethodType, handle, handle.type()).getTarget().invoke();
    }

    public static boolean supportsJsonSerializable(Class<?> bodyContentClass) {
        return JSON_SERIALIZABLE_SUPPORTED && JSON_SERIALIZABLE.isAssignableFrom(bodyContentClass);
    }

    static ByteBuffer serializeAsJsonSerializable(Object jsonSerializable) throws IOException {
        try (AccessibleByteArrayOutputStream outputStream = new AccessibleByteArrayOutputStream();){
            ByteBuffer byteBuffer;
            block11: {
                Closeable jsonWriter = JSON_WRITER_CREATOR.createJsonWriter(outputStream);
                try {
                    JSON_WRITER_WRITE_JSON_SERIALIZABLE.writeJson(jsonWriter, jsonSerializable);
                    JSON_WRITER_FLUSH.flush(jsonWriter);
                    byteBuffer = ByteBuffer.wrap(outputStream.toByteArray(), 0, outputStream.count());
                    if (jsonWriter == null) break block11;
                }
                catch (Throwable throwable) {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonWriter.close();
            }
            return byteBuffer;
        }
    }

    public static Object deserializeAsJsonSerializable(Class<?> jsonSerializable, byte[] json) throws IOException {
        Object object;
        block12: {
            if (!JSON_SERIALIZABLE_SUPPORTED) {
                return null;
            }
            if (FROM_JSON_CACHE.size() >= 10000) {
                FROM_JSON_CACHE.clear();
            }
            MethodHandle readJson = FROM_JSON_CACHE.computeIfAbsent(jsonSerializable, clazz -> {
                try {
                    MethodHandles.Lookup lookup = ReflectionUtils.getLookupToUse(clazz);
                    return lookup.unreflect(jsonSerializable.getDeclaredMethod("fromJson", JSON_READER));
                }
                catch (Exception e) {
                    throw LOGGER.logExceptionAsError(new IllegalStateException(e));
                }
            });
            Closeable jsonReader = JSON_READER_CREATOR.createJsonReader(json);
            try {
                object = readJson.invoke(jsonReader);
                if (jsonReader == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof Exception) {
                        throw new IOException(e);
                    }
                    throw (Error)e;
                }
            }
            jsonReader.close();
        }
        return object;
    }

    public static boolean supportsXmlSerializable(Class<?> bodyContentClass) {
        return XML_SERIALIZABLE_SUPPORTED && XML_SERIALIZABLE.isAssignableFrom(bodyContentClass);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static ByteBuffer serializeAsXmlSerializable(Object bodyContent) throws IOException {
        try (AccessibleByteArrayOutputStream outputStream = new AccessibleByteArrayOutputStream();){
            ByteBuffer byteBuffer;
            block14: {
                AutoCloseable xmlWriter = XML_WRITER_CREATOR.createXmlWriter(outputStream);
                try {
                    XML_WRITER_WRITE_XML_START_DOCUMENT.writeStartDocument(xmlWriter);
                    XML_WRITER_WRITE_XML_SERIALIZABLE.writeXml(xmlWriter, bodyContent);
                    XML_WRITER_FLUSH.flush(xmlWriter);
                    byteBuffer = ByteBuffer.wrap(outputStream.toByteArray(), 0, outputStream.count());
                    if (xmlWriter == null) break block14;
                }
                catch (Throwable throwable) {
                    if (xmlWriter != null) {
                        try {
                            xmlWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                xmlWriter.close();
            }
            return byteBuffer;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public static Object deserializeAsXmlSerializable(Class<?> xmlSerializable, byte[] xml) throws IOException {
        Object object;
        block12: {
            if (!XML_SERIALIZABLE_SUPPORTED) {
                return null;
            }
            if (FROM_XML_CACHE.size() >= 10000) {
                FROM_XML_CACHE.clear();
            }
            MethodHandle readXml = FROM_XML_CACHE.computeIfAbsent(xmlSerializable, clazz -> {
                try {
                    MethodHandles.Lookup lookup = ReflectionUtils.getLookupToUse(clazz);
                    return lookup.unreflect(xmlSerializable.getMethod("fromXml", XML_READER));
                }
                catch (Exception e) {
                    throw LOGGER.logExceptionAsError(new IllegalStateException(e));
                }
            });
            AutoCloseable xmlReader = XML_READER_CREATOR.createXmlReader(xml);
            try {
                object = readXml.invoke(xmlReader);
                if (xmlReader == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (xmlReader != null) {
                        try {
                            xmlReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof Exception) {
                        throw new IOException(e);
                    }
                    throw (Error)e;
                }
            }
            xmlReader.close();
        }
        return object;
    }

    private ReflectionSerializable() {
    }

    static {
        MethodHandles.Lookup defaultLookup = MethodHandles.lookup();
        Class<?> jsonSerializable = null;
        Class<?> jsonReader = null;
        CreateJsonReader jsonReaderCreator = null;
        CreateJsonWriter jsonWriterCreator = null;
        JsonWriterWriteJson jsonWriterWriteJsonSerializable = null;
        JsonWriterFlush jsonWriterFlush = null;
        boolean jsonSerializableSupported = false;
        try {
            jsonSerializable = Class.forName("com.azure.json.JsonSerializable");
            jsonReader = Class.forName("com.azure.json.JsonReader");
            Class<?> jsonProviders = Class.forName("com.azure.json.JsonProviders");
            MethodHandles.Lookup lookup = ReflectionUtils.getLookupToUse(jsonProviders);
            jsonReaderCreator = ReflectionSerializable.createMetaFactory(jsonProviders.getDeclaredMethod("createReader", byte[].class), lookup, CreateJsonReader.class, MethodType.methodType(Closeable.class, byte[].class), defaultLookup);
            jsonWriterCreator = ReflectionSerializable.createMetaFactory(jsonProviders.getDeclaredMethod("createWriter", OutputStream.class), lookup, CreateJsonWriter.class, MethodType.methodType(Closeable.class, OutputStream.class), defaultLookup);
            Class<?> jsonWriter = Class.forName("com.azure.json.JsonWriter");
            jsonWriterWriteJsonSerializable = ReflectionSerializable.createMetaFactory(jsonWriter.getDeclaredMethod("writeJson", jsonSerializable), lookup, JsonWriterWriteJson.class, MethodType.methodType(Object.class, Object.class, Object.class), defaultLookup);
            jsonWriterFlush = ReflectionSerializable.createMetaFactory(jsonWriter.getDeclaredMethod("flush", new Class[0]), lookup, JsonWriterFlush.class, MethodType.methodType(Object.class, Object.class), defaultLookup);
            jsonSerializableSupported = true;
        }
        catch (Throwable e) {
            if (e instanceof LinkageError || e instanceof Exception) {
                LOGGER.log(LogLevel.VERBOSE, () -> "JsonSerializable serialization and deserialization isn't supported. If it is required add a dependency of 'com.azure:azure-json', or another dependencies which include 'com.azure:azure-json' as a transitive dependency. If your application runs as expected this informational message can be ignored.");
            }
            throw (Error)e;
        }
        JSON_SERIALIZABLE = jsonSerializable;
        JSON_READER = jsonReader;
        JSON_READER_CREATOR = jsonReaderCreator;
        JSON_WRITER_CREATOR = jsonWriterCreator;
        JSON_WRITER_WRITE_JSON_SERIALIZABLE = jsonWriterWriteJsonSerializable;
        JSON_WRITER_FLUSH = jsonWriterFlush;
        JSON_SERIALIZABLE_SUPPORTED = jsonSerializableSupported;
        FROM_JSON_CACHE = JSON_SERIALIZABLE_SUPPORTED ? new ConcurrentHashMap() : null;
        Class<?> xmlSerializable = null;
        Class<?> xmlReader = null;
        CreateXmlReader xmlReaderCreator = null;
        CreateXmlWriter xmlWriterCreator = null;
        XmlWriterWriteStartDocument xmlWriterWriteStartDocument = null;
        XmlWriterWriteXml xmlWriterWriteXmlSerializable = null;
        XmlWriterFlush xmlWriterFlush = null;
        boolean xmlSerializableSupported = false;
        try {
            xmlSerializable = Class.forName("com.azure.xml.XmlSerializable");
            xmlReader = Class.forName("com.azure.xml.XmlReader");
            Class<?> xmlProviders = Class.forName("com.azure.xml.XmlProviders");
            MethodHandles.Lookup lookup = ReflectionUtils.getLookupToUse(xmlProviders);
            xmlReaderCreator = ReflectionSerializable.createMetaFactory(xmlProviders.getDeclaredMethod("createReader", byte[].class), lookup, CreateXmlReader.class, MethodType.methodType(AutoCloseable.class, byte[].class), defaultLookup);
            xmlWriterCreator = ReflectionSerializable.createMetaFactory(xmlProviders.getDeclaredMethod("createWriter", OutputStream.class), lookup, CreateXmlWriter.class, MethodType.methodType(AutoCloseable.class, OutputStream.class), defaultLookup);
            Class<?> xmlWriter = Class.forName("com.azure.xml.XmlWriter");
            xmlWriterWriteStartDocument = ReflectionSerializable.createMetaFactory(xmlWriter.getDeclaredMethod("writeStartDocument", new Class[0]), lookup, XmlWriterWriteStartDocument.class, MethodType.methodType(Object.class, Object.class), defaultLookup);
            xmlWriterWriteXmlSerializable = ReflectionSerializable.createMetaFactory(xmlWriter.getDeclaredMethod("writeXml", xmlSerializable), lookup, XmlWriterWriteXml.class, MethodType.methodType(Object.class, Object.class, Object.class), defaultLookup);
            xmlWriterFlush = ReflectionSerializable.createMetaFactory(xmlWriter.getDeclaredMethod("flush", new Class[0]), lookup, XmlWriterFlush.class, MethodType.methodType(Object.class, Object.class), defaultLookup);
            xmlSerializableSupported = true;
        }
        catch (Throwable e) {
            if (e instanceof LinkageError || e instanceof Exception) {
                LOGGER.log(LogLevel.VERBOSE, () -> "XmlSerializable serialization and deserialization isn't supported. If it is required add a dependency of 'com.azure:azure-xml', or another dependencies which include 'com.azure:azure-xml' as a transitive dependency. If your application runs as expected this informational message can be ignored.");
            }
            throw (Error)e;
        }
        XML_SERIALIZABLE = xmlSerializable;
        XML_READER = xmlReader;
        XML_READER_CREATOR = xmlReaderCreator;
        XML_WRITER_CREATOR = xmlWriterCreator;
        XML_WRITER_WRITE_XML_START_DOCUMENT = xmlWriterWriteStartDocument;
        XML_WRITER_WRITE_XML_SERIALIZABLE = xmlWriterWriteXmlSerializable;
        XML_WRITER_FLUSH = xmlWriterFlush;
        XML_SERIALIZABLE_SUPPORTED = xmlSerializableSupported;
        FROM_XML_CACHE = XML_SERIALIZABLE_SUPPORTED ? new ConcurrentHashMap() : null;
    }

    @FunctionalInterface
    private static interface CreateJsonWriter {
        public Closeable createJsonWriter(OutputStream var1) throws IOException;
    }

    @FunctionalInterface
    private static interface JsonWriterWriteJson {
        public Object writeJson(Object var1, Object var2) throws IOException;
    }

    @FunctionalInterface
    private static interface JsonWriterFlush {
        public Object flush(Object var1) throws IOException;
    }

    @FunctionalInterface
    private static interface CreateJsonReader {
        public Closeable createJsonReader(byte[] var1) throws IOException;
    }

    @FunctionalInterface
    private static interface CreateXmlWriter {
        public AutoCloseable createXmlWriter(OutputStream var1) throws XMLStreamException;
    }

    @FunctionalInterface
    private static interface XmlWriterWriteStartDocument {
        public Object writeStartDocument(Object var1) throws XMLStreamException;
    }

    @FunctionalInterface
    private static interface XmlWriterWriteXml {
        public Object writeXml(Object var1, Object var2) throws XMLStreamException;
    }

    @FunctionalInterface
    private static interface XmlWriterFlush {
        public Object flush(Object var1) throws XMLStreamException;
    }

    @FunctionalInterface
    private static interface CreateXmlReader {
        public AutoCloseable createXmlReader(byte[] var1) throws XMLStreamException;
    }
}

