/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.PermissionMode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Locale;

public final class Permission
extends Resource {
    public Permission() {
    }

    public Permission(ObjectNode jsonNode) {
        super(jsonNode);
    }

    @Override
    public Permission setId(String id) {
        super.setId(id);
        return this;
    }

    public String getResourceLink() {
        return super.getString("resource");
    }

    public void setResourceLink(String resourceLink) {
        this.set("resource", resourceLink);
    }

    public PermissionMode getPermissionMode() {
        String value = super.getString("permissionMode");
        return PermissionMode.valueOf(StringUtils.upperCase(value));
    }

    public void setPermissionMode(PermissionMode permissionMode) {
        this.set("permissionMode", permissionMode.toString().toLowerCase(Locale.ROOT));
    }

    public String getToken() {
        return super.getString("_token");
    }

    public PartitionKey getResourcePartitionKey() {
        PartitionKey key = null;
        Object value = super.get("resourcePartitionKey");
        if (value != null) {
            ArrayNode arrayValue = (ArrayNode)value;
            key = new PartitionKey(JsonSerializable.getValue(arrayValue.get(0)));
        }
        return key;
    }

    public void setResourcePartitionKey(PartitionKey partitionkey) {
        Preconditions.checkNotNull(partitionkey, "Partition key can not be null");
        this.set("resourcePartitionKey", ModelBridgeInternal.getPartitionKeyInternal(partitionkey).toObjectArray());
    }
}

