/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.ConsoleLoggingRegistryFactory;
import com.azure.cosmos.implementation.directconnectivity.RntbdTransportClient;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdMetricsCompletionRecorder;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestRecord;
import com.azure.cosmos.implementation.guava25.net.PercentEscaper;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder(value={"tags", "concurrentRequests", "requests", "responseErrors", "responseSuccesses", "completionRate", "responseRate", "requestSize", "responseSize", "channelsAcquired", "channelsAvailable", "requestQueueLength", "usedDirectMemory", "usedHeapMemory"})
public final class RntbdMetrics
implements RntbdMetricsCompletionRecorder {
    private static final PercentEscaper PERCENT_ESCAPER;
    private static final Logger logger;
    private static final CompositeMeterRegistry registry;
    private static boolean hasAnyRegistry;
    private final RntbdEndpoint endpoint;
    private final DistributionSummary requestSize;
    private final Timer requests;
    private final Timer responseErrors;
    private final DistributionSummary responseSize;
    private final Timer responseSuccesses;
    private final Tags tags;
    private final RntbdTransportClient transportClient;

    public static boolean isEmpty() {
        return !hasAnyRegistry;
    }

    private RntbdMetrics(RntbdTransportClient client, RntbdEndpoint endpoint) {
        this.transportClient = client;
        this.endpoint = endpoint;
        this.tags = Tags.of((Tag[])new Tag[]{client.tag(), endpoint.tag()});
        this.requests = registry.timer(RntbdMetrics.nameOf("requests"), (Iterable)this.tags);
        this.responseErrors = registry.timer(RntbdMetrics.nameOf("responseErrors"), (Iterable)this.tags);
        this.responseSuccesses = registry.timer(RntbdMetrics.nameOf("responseSuccesses"), (Iterable)this.tags);
        Gauge.builder((String)RntbdMetrics.nameOf("endpoints"), (Object)client, RntbdTransportClient::endpointCount).description("endpoint count").tag(client.tag().getKey(), client.tag().getValue()).register((MeterRegistry)registry);
        Gauge.builder((String)RntbdMetrics.nameOf("endpointsEvicted"), (Object)client, RntbdTransportClient::endpointEvictionCount).description("endpoint eviction count").tag(client.tag().getKey(), client.tag().getValue()).register((MeterRegistry)registry);
        Gauge.builder((String)RntbdMetrics.nameOf("concurrentRequests"), (Object)endpoint, RntbdEndpoint::concurrentRequests).description("executing or queued request count").tags((Iterable)this.tags).register((MeterRegistry)registry);
        Gauge.builder((String)RntbdMetrics.nameOf("requestQueueLength"), (Object)endpoint, RntbdEndpoint::requestQueueLength).description("queued request count").tags((Iterable)this.tags).register((MeterRegistry)registry);
        Gauge.builder((String)RntbdMetrics.nameOf("channelsAcquired"), (Object)endpoint, RntbdEndpoint::channelsAcquiredMetric).description("acquired channel count").tags((Iterable)this.tags).register((MeterRegistry)registry);
        Gauge.builder((String)RntbdMetrics.nameOf("channelsAvailable"), (Object)endpoint, RntbdEndpoint::channelsAvailableMetric).description("available channel count").tags((Iterable)this.tags).register((MeterRegistry)registry);
        Gauge.builder((String)RntbdMetrics.nameOf("usedDirectMemory"), (Object)endpoint, x -> x.usedDirectMemory()).description("Java direct memory usage (MiB)").baseUnit("bytes").tags((Iterable)this.tags).register((MeterRegistry)registry);
        Gauge.builder((String)RntbdMetrics.nameOf("usedHeapMemory"), (Object)endpoint, x -> x.usedHeapMemory()).description("Java heap memory usage (MiB)").baseUnit("MiB").tags((Iterable)this.tags).register((MeterRegistry)registry);
        this.requestSize = DistributionSummary.builder((String)RntbdMetrics.nameOf("requestSize")).description("Request size (bytes)").baseUnit("bytes").tags((Iterable)this.tags).register((MeterRegistry)registry);
        this.responseSize = DistributionSummary.builder((String)RntbdMetrics.nameOf("responseSize")).description("Response size (bytes)").baseUnit("bytes").tags((Iterable)this.tags).register((MeterRegistry)registry);
    }

    static RntbdMetricsCompletionRecorder create(RntbdTransportClient client, RntbdEndpoint endpoint) {
        return new RntbdMetrics(client, endpoint);
    }

    public static void add(MeterRegistry registry) {
        hasAnyRegistry = true;
        RntbdMetrics.registry.add(registry);
    }

    @JsonProperty
    public int channelsAcquired() {
        return this.endpoint.channelsAcquiredMetric();
    }

    @JsonProperty
    public int channelsAvailable() {
        return this.endpoint.channelsAvailableMetric();
    }

    @JsonProperty
    public double completionRate() {
        return (double)this.responseSuccesses.count() / (double)this.requests.count();
    }

    @JsonProperty
    public long concurrentRequests() {
        return this.endpoint.concurrentRequests();
    }

    @JsonProperty
    public int endpoints() {
        return this.transportClient.endpointCount();
    }

    @JsonProperty
    public int requestQueueLength() {
        return this.endpoint.requestQueueLength();
    }

    @JsonProperty
    public HistogramSnapshot requestSize() {
        return this.requestSize.takeSnapshot();
    }

    @JsonProperty
    public HistogramSnapshot requests() {
        return this.requests.takeSnapshot();
    }

    @JsonProperty
    public HistogramSnapshot responseErrors() {
        return this.responseErrors.takeSnapshot();
    }

    @JsonProperty
    public double responseRate() {
        return (double)this.responseSuccesses.count() / (double)(this.requests.count() + (long)this.endpoint.concurrentRequests());
    }

    @JsonProperty
    public HistogramSnapshot responseSize() {
        return this.responseSize.takeSnapshot();
    }

    @JsonProperty
    public HistogramSnapshot responseSuccesses() {
        return this.responseSuccesses.takeSnapshot();
    }

    @JsonProperty
    public Iterable<Tag> tags() {
        return this.tags;
    }

    @JsonProperty
    public long usedDirectMemory() {
        return this.endpoint.usedDirectMemory();
    }

    @JsonProperty
    public long usedHeapMemory() {
        return this.endpoint.usedHeapMemory();
    }

    @Override
    public void markComplete(RntbdRequestRecord requestRecord) {
        requestRecord.stop(this.requests, requestRecord.isCompletedExceptionally() ? this.responseErrors : this.responseSuccesses);
        if (!requestRecord.isCancelled()) {
            this.requestSize.record((double)requestRecord.requestLength());
            this.responseSize.record((double)requestRecord.responseLength());
        }
    }

    public String toString() {
        return RntbdObjectMapper.toString(this);
    }

    static String escape(String value) {
        return PERCENT_ESCAPER.escape(value);
    }

    private static String nameOf(String member) {
        return "azure.cosmos.directTcp." + member;
    }

    static {
        block3: {
            PERCENT_ESCAPER = new PercentEscaper("_-", false);
            logger = LoggerFactory.getLogger(RntbdMetrics.class);
            registry = new CompositeMeterRegistry();
            hasAnyRegistry = false;
            try {
                int step = Integer.getInteger("azure.cosmos.monitoring.consoleLogging.step", 0);
                if (step > 0) {
                    RntbdMetrics.add(ConsoleLoggingRegistryFactory.create(step));
                }
            }
            catch (Throwable throwable) {
                logger.error("failed to initialize console logging registry due to ", throwable);
                if (!(throwable instanceof Error)) break block3;
                throw (Error)throwable;
            }
        }
    }
}

