/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.routing.MurmurHash3_128;
import com.azure.cosmos.implementation.routing.UInt128;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class DistinctHash {
    private static final UInt128 ROOT_HASH_SEED = new UInt128(-4629078511313689929L, -8626961734759559393L);

    public static UInt128 getHash(Object resource) throws IOException {
        return DistinctHash.getHash(resource, ROOT_HASH_SEED);
    }

    private static UInt128 getHash(Object resource, UInt128 seed) throws IOException {
        if (resource == null) {
            return MurmurHash3_128.hash128(HashSeeds.NULL, seed);
        }
        if (resource instanceof JsonSerializable) {
            return DistinctHash.getHashFromJsonSerializable((JsonSerializable)resource, seed);
        }
        if (resource instanceof List) {
            return DistinctHash.getHashFromIterator(((List)resource).iterator(), seed);
        }
        if (resource instanceof Boolean) {
            return (Boolean)resource != false ? MurmurHash3_128.hash128(HashSeeds.TRUE, seed) : MurmurHash3_128.hash128(HashSeeds.FALSE, seed);
        }
        if (resource instanceof Integer) {
            UInt128 hash = MurmurHash3_128.hash128(HashSeeds.INTEGER, seed);
            return MurmurHash3_128.hash128(resource, hash);
        }
        if (resource instanceof Long) {
            UInt128 hash = MurmurHash3_128.hash128(HashSeeds.LONG, seed);
            return MurmurHash3_128.hash128(resource, hash);
        }
        if (resource instanceof Double) {
            UInt128 hash = MurmurHash3_128.hash128(HashSeeds.DOUBLE, seed);
            return MurmurHash3_128.hash128(resource, hash);
        }
        if (resource instanceof String) {
            UInt128 hash = MurmurHash3_128.hash128(HashSeeds.STRING, seed);
            return MurmurHash3_128.hash128(resource, hash);
        }
        if (resource instanceof NullNode) {
            return DistinctHash.getHash(null, seed);
        }
        if (resource instanceof ValueNode) {
            return DistinctHash.getHash(JsonSerializable.getValue((JsonNode)resource), seed);
        }
        if (resource instanceof ArrayNode) {
            return DistinctHash.getHashFromIterator(((ArrayNode)resource).iterator(), seed);
        }
        if (resource instanceof ObjectNode) {
            return DistinctHash.getHashFromObjectNode((ObjectNode)resource, seed);
        }
        throw new IllegalArgumentException(String.format("Unexpected type: %s", resource.getClass().toString()));
    }

    private static UInt128 getHashFromJsonSerializable(JsonSerializable resource, UInt128 seed) throws IOException {
        resource.populatePropertyBag();
        return DistinctHash.getHash(resource.getPropertyBag(), seed);
    }

    private static UInt128 getHashFromObjectNode(ObjectNode objectNode, UInt128 seed) throws IOException {
        UInt128 hash = MurmurHash3_128.hash128(HashSeeds.OBJECT, seed);
        UInt128 intermediateHash = UInt128.ZERO;
        Iterator children = objectNode.fields();
        while (children.hasNext()) {
            Map.Entry child = (Map.Entry)children.next();
            UInt128 nameHash = MurmurHash3_128.hash128((String)child.getKey(), HashSeeds.PROPERTY_NAME);
            UInt128 propertyHash = DistinctHash.getHash(child.getValue(), nameHash);
            intermediateHash = intermediateHash.xor(propertyHash);
        }
        if (!intermediateHash.equals(UInt128.ZERO)) {
            hash = MurmurHash3_128.hash128(intermediateHash, hash);
        }
        return hash;
    }

    private static <T> UInt128 getHashFromIterator(Iterator<T> iterator, UInt128 seed) throws IOException {
        UInt128 hash = MurmurHash3_128.hash128(HashSeeds.ARRAY, seed);
        int index = 0;
        while (iterator.hasNext()) {
            UInt128 arrayItemSeed = HashSeeds.ARRAY_INDEX.add(index);
            hash = MurmurHash3_128.hash128(hash, DistinctHash.getHash(iterator.next(), arrayItemSeed));
        }
        return hash;
    }

    private static class HashSeeds {
        public static final UInt128 NULL = new UInt128(1405394163615191012L, 1543768802584751688L);
        public static final UInt128 FALSE = new UInt128(-4486058569009744884L, -1586240908324712227L);
        public static final UInt128 TRUE = new UInt128(-545697793054790028L, 8684215748539357277L);
        public static final UInt128 STRING = new UInt128(7058617304298310907L, 668815231925573341L);
        public static final UInt128 ARRAY = new UInt128(-407792364492570226L, -6911810276445736683L);
        public static final UInt128 OBJECT = new UInt128(8625103211509509936L, 4453805435564205129L);
        public static final UInt128 INTEGER = new UInt128(225422494785158769L, -759456726426976347L);
        public static final UInt128 LONG = new UInt128(-1327511890866772424L, 961293960192956521L);
        public static final UInt128 DOUBLE = new UInt128(7132374477586391968L, -1592426574986492925L);
        public static final UInt128 ARRAY_INDEX = new UInt128(-142582451126027879L, 6565336862697309587L);
        public static final UInt128 PROPERTY_NAME = new UInt128(-3957012741951509878L, 8974516184215864884L);

        private HashSeeds() {
        }
    }
}

