/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.extensions.implementation.token;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.extensions.implementation.enums.AuthProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class AccessTokenResolverOptions {
    private static final ClientLogger LOGGER = new ClientLogger(AccessTokenResolverOptions.class);
    private static final Map<String, String> OSS_RDBMS_SCOPE_MAP = new HashMap<String, String>(){
        {
            this.put("https://login.microsoftonline.com/", "https://ossrdbms-aad.database.windows.net/.default");
            this.put("https://login.chinacloudapi.cn/", "https://ossrdbms-aad.database.chinacloudapi.cn/.default");
            this.put("https://login.microsoftonline.de/", "https://ossrdbms-aad.database.cloudapi.de/.default");
            this.put("https://login.microsoftonline.us/", "https://ossrdbms-aad.database.usgovcloudapi.net/.default");
        }
    };
    private String claims;
    private String tenantId;
    private String[] scopes;

    public AccessTokenResolverOptions() {
    }

    public AccessTokenResolverOptions(Properties properties) {
        this.tenantId = AuthProperty.TENANT_ID.get(properties);
        this.claims = AuthProperty.CLAIMS.get(properties);
        String scopeProperty = AuthProperty.SCOPES.get(properties);
        if (scopeProperty == null) {
            scopeProperty = this.getDefaultScope(properties);
        }
        this.scopes = scopeProperty.split(",");
    }

    private String getDefaultScope(Properties properties) {
        String ossrdbmsScope = OSS_RDBMS_SCOPE_MAP.get("https://login.microsoftonline.com/");
        String authorityHost = AuthProperty.AUTHORITY_HOST.get(properties);
        if ("https://login.microsoftonline.com/".startsWith(authorityHost)) {
            ossrdbmsScope = OSS_RDBMS_SCOPE_MAP.get("https://login.microsoftonline.com/");
        } else if ("https://login.chinacloudapi.cn/".startsWith(authorityHost)) {
            ossrdbmsScope = OSS_RDBMS_SCOPE_MAP.get("https://login.chinacloudapi.cn/");
        } else if ("https://login.microsoftonline.de/".startsWith(authorityHost)) {
            ossrdbmsScope = OSS_RDBMS_SCOPE_MAP.get("https://login.microsoftonline.de/");
        } else if ("https://login.microsoftonline.us/".startsWith(authorityHost)) {
            ossrdbmsScope = OSS_RDBMS_SCOPE_MAP.get("https://login.microsoftonline.us/");
        }
        LOGGER.info("Ossrdbms scope set to {}.", new Object[]{ossrdbmsScope});
        return ossrdbmsScope;
    }

    public String getClaims() {
        return this.claims;
    }

    public void setClaims(String claims) {
        this.claims = claims;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String[] getScopes() {
        return this.scopes == null ? null : (String[])this.scopes.clone();
    }

    public void setScopes(String[] scopes) {
        this.scopes = (String[])scopes.clone();
    }
}

