/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.amqp.client.traits.AmqpTrait;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.annotation.ServiceClientProtocol;
import com.azure.core.client.traits.AzureNamedKeyCredentialTrait;
import com.azure.core.client.traits.AzureSasCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.ConnectionStringTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.eventhubs.EventHubBufferedProducerAsyncClient;
import com.azure.messaging.eventhubs.EventHubBufferedProducerClient;
import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.PartitionResolver;
import com.azure.messaging.eventhubs.models.SendBatchFailedContext;
import com.azure.messaging.eventhubs.models.SendBatchSucceededContext;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;

@ServiceClientBuilder(serviceClients={EventHubBufferedProducerAsyncClient.class, EventHubBufferedProducerClient.class}, protocol=ServiceClientProtocol.AMQP)
public final class EventHubBufferedProducerClientBuilder
implements TokenCredentialTrait<EventHubBufferedProducerClientBuilder>,
AzureNamedKeyCredentialTrait<EventHubBufferedProducerClientBuilder>,
ConnectionStringTrait<EventHubBufferedProducerClientBuilder>,
AzureSasCredentialTrait<EventHubBufferedProducerClientBuilder>,
AmqpTrait<EventHubBufferedProducerClientBuilder>,
ConfigurationTrait<EventHubBufferedProducerClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(EventHubBufferedProducerClientBuilder.class);
    private final EventHubClientBuilder builder;
    private final EventHubBufferedProducerAsyncClient.BufferedProducerClientOptions clientOptions = new EventHubBufferedProducerAsyncClient.BufferedProducerClientOptions();
    private final PartitionResolver partitionResolver = new PartitionResolver();
    private AmqpRetryOptions retryOptions;

    public EventHubBufferedProducerClientBuilder() {
        this.builder = new EventHubClientBuilder();
    }

    public EventHubBufferedProducerClientBuilder clientOptions(ClientOptions clientOptions) {
        this.builder.clientOptions(clientOptions);
        return this;
    }

    public EventHubBufferedProducerClientBuilder configuration(Configuration configuration) {
        this.builder.configuration(configuration);
        return this;
    }

    public EventHubBufferedProducerClientBuilder connectionString(String connectionString) {
        this.builder.connectionString(connectionString);
        return this;
    }

    public EventHubBufferedProducerClientBuilder connectionString(String connectionString, String eventHubName) {
        this.builder.connectionString(connectionString, eventHubName);
        return this;
    }

    public EventHubBufferedProducerClientBuilder credential(String fullyQualifiedNamespace, String eventHubName, TokenCredential credential) {
        this.builder.credential(fullyQualifiedNamespace, eventHubName, credential);
        return this;
    }

    public EventHubBufferedProducerClientBuilder credential(String fullyQualifiedNamespace, String eventHubName, AzureNamedKeyCredential credential) {
        this.builder.credential(fullyQualifiedNamespace, eventHubName, credential);
        return this;
    }

    public EventHubBufferedProducerClientBuilder credential(String fullyQualifiedNamespace, String eventHubName, AzureSasCredential credential) {
        this.builder.credential(fullyQualifiedNamespace, eventHubName, credential);
        return this;
    }

    public EventHubBufferedProducerClientBuilder credential(AzureNamedKeyCredential credential) {
        this.builder.credential(credential);
        return this;
    }

    public EventHubBufferedProducerClientBuilder credential(AzureSasCredential credential) {
        this.builder.credential(credential);
        return this;
    }

    public EventHubBufferedProducerClientBuilder credential(TokenCredential credential) {
        this.builder.credential(credential);
        return this;
    }

    public EventHubBufferedProducerClientBuilder customEndpointAddress(String customEndpointAddress) {
        this.builder.customEndpointAddress(customEndpointAddress);
        return this;
    }

    EventHubBufferedProducerClientBuilder enableIdempotentRetries(boolean enableIdempotentRetries) {
        this.clientOptions.setEnableIdempotentRetries(enableIdempotentRetries);
        return this;
    }

    public EventHubBufferedProducerClientBuilder fullyQualifiedNamespace(String fullyQualifiedNamespace) {
        this.builder.fullyQualifiedNamespace(fullyQualifiedNamespace);
        return this;
    }

    public EventHubBufferedProducerClientBuilder eventHubName(String eventHubName) {
        this.builder.eventHubName(eventHubName);
        return this;
    }

    EventHubBufferedProducerClientBuilder maxConcurrentSends(int maxConcurrentSends) {
        this.clientOptions.setMaxConcurrentSends(maxConcurrentSends);
        return this;
    }

    EventHubBufferedProducerClientBuilder maxConcurrentSendsPerPartition(int maxConcurrentSendsPerPartition) {
        this.clientOptions.setMaxConcurrentSendsPerPartition(maxConcurrentSendsPerPartition);
        return this;
    }

    public EventHubBufferedProducerClientBuilder maxEventBufferLengthPerPartition(int maxEventBufferLengthPerPartition) {
        this.clientOptions.maxEventBufferLengthPerPartition(maxEventBufferLengthPerPartition);
        return this;
    }

    public EventHubBufferedProducerClientBuilder maxWaitTime(Duration maxWaitTime) {
        this.clientOptions.setMaxWaitTime(maxWaitTime);
        return this;
    }

    public EventHubBufferedProducerClientBuilder onSendBatchFailed(Consumer<SendBatchFailedContext> sendFailedContext) {
        this.clientOptions.setSendFailedContext(sendFailedContext);
        return this;
    }

    public EventHubBufferedProducerClientBuilder onSendBatchSucceeded(Consumer<SendBatchSucceededContext> sendSucceededContext) {
        this.clientOptions.setSendSucceededContext(sendSucceededContext);
        return this;
    }

    public EventHubBufferedProducerClientBuilder proxyOptions(ProxyOptions proxyOptions) {
        this.builder.proxyOptions(proxyOptions);
        return this;
    }

    public EventHubBufferedProducerClientBuilder retryOptions(AmqpRetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        this.builder.retryOptions(retryOptions);
        return this;
    }

    public EventHubBufferedProducerClientBuilder transportType(AmqpTransportType transport) {
        this.builder.transportType(transport);
        return this;
    }

    public EventHubBufferedProducerAsyncClient buildAsyncClient() {
        if (Objects.isNull(this.clientOptions.getSendSucceededContext())) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'onSendBatchSucceeded' cannot be null."));
        }
        if (Objects.isNull(this.clientOptions.getSendFailedContext())) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'onSendBatchFailed' cannot be null."));
        }
        if (Objects.isNull(this.clientOptions.getMaxWaitTime())) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'maxWaitTime' cannot be null."));
        }
        if (this.clientOptions.getMaxEventBufferLengthPerPartition() < 1) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'maxEventBufferLengthPerPartition' cannot be less than 1."));
        }
        if (this.clientOptions.getMaxConcurrentSends() < 1) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'maxConcurrentSends' cannot be less than 1."));
        }
        if (this.clientOptions.getMaxConcurrentSendsPerPartition() < 1) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'maxConcurrentSendsPerPartition' cannot be less than 1."));
        }
        AmqpRetryOptions options = this.retryOptions == null ? EventHubClientBuilder.DEFAULT_RETRY : this.retryOptions;
        return new EventHubBufferedProducerAsyncClient(this.builder, this.clientOptions, this.partitionResolver, options, this.builder.createTracer());
    }

    public EventHubBufferedProducerClient buildClient() {
        AmqpRetryOptions options = this.retryOptions == null ? EventHubClientBuilder.DEFAULT_RETRY : this.retryOptions;
        return new EventHubBufferedProducerClient(this.buildAsyncClient(), options.getTryTimeout());
    }
}

