/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.util.Context;
import com.azure.core.util.metrics.Meter;
import com.azure.core.util.tracing.SpanKind;
import com.azure.core.util.tracing.StartSpanOptions;
import com.azure.core.util.tracing.Tracer;
import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.EventDataBatch;
import com.azure.messaging.eventhubs.implementation.instrumentation.EventHubsMetricsProvider;
import com.azure.messaging.eventhubs.implementation.instrumentation.EventHubsTracer;
import com.azure.messaging.eventhubs.implementation.instrumentation.InstrumentationScope;
import com.azure.messaging.eventhubs.implementation.instrumentation.OperationName;
import reactor.core.publisher.Mono;

class EventHubsProducerInstrumentation {
    public static final EventHubsProducerInstrumentation NOOP_INSTANCE = new EventHubsProducerInstrumentation(null, null, "NOOP_HOST", "NOOP_ENTITY");
    private final EventHubsTracer tracer;
    private final EventHubsMetricsProvider meter;

    EventHubsProducerInstrumentation(Tracer tracer, Meter meter, String fullyQualifiedName, String entityName) {
        this.tracer = new EventHubsTracer(tracer, fullyQualifiedName, entityName, null);
        this.meter = new EventHubsMetricsProvider(meter, fullyQualifiedName, entityName, null);
    }

    <T> Mono<T> sendBatch(Mono<T> publisher, EventDataBatch batch) {
        if (!this.isEnabled()) {
            return publisher;
        }
        return Mono.using(() -> new InstrumentationScope(this.tracer, this.meter, (m, s) -> m.reportBatchSend(batch.getCount(), batch.getPartitionId(), (InstrumentationScope)s)).setSpan(this.startPublishSpanWithLinks(batch)), scope -> publisher.doOnError(scope::setError).doOnCancel(scope::setCancelled), InstrumentationScope::close);
    }

    public EventHubsTracer getTracer() {
        return this.tracer;
    }

    public <T> Mono<T> instrumentMono(Mono<T> publisher, OperationName operationName, String partitionId) {
        if (!this.isEnabled()) {
            return publisher;
        }
        return Mono.using(() -> new InstrumentationScope(this.tracer, this.meter, (m, s) -> m.reportGenericOperationDuration(operationName, partitionId, (InstrumentationScope)s)).setSpan(this.tracer.startGenericOperationSpan(operationName, partitionId, Context.NONE)), scope -> publisher.doOnError(scope::setError).doOnCancel(scope::setCancelled).contextWrite(c -> c.put((Object)"trace-context", (Object)scope.getSpan())), InstrumentationScope::close);
    }

    private Context startPublishSpanWithLinks(EventDataBatch batch) {
        if (!this.tracer.isEnabled()) {
            return Context.NONE;
        }
        StartSpanOptions startOptions = this.tracer.createStartOptions(SpanKind.CLIENT, OperationName.SEND, null);
        if (batch != null) {
            startOptions.setAttribute("messaging.batch.message_count", (Object)batch.getCount());
            if (batch.getPartitionId() != null) {
                startOptions.setAttribute("messaging.destination.partition.id", (Object)batch.getPartitionId());
            }
            for (EventData event : batch.getEvents()) {
                startOptions.addLink(this.tracer.createProducerLink(event.getProperties(), event.getContext()));
            }
        }
        return this.tracer.startSpan(OperationName.SEND, startOptions, Context.NONE);
    }

    private boolean isEnabled() {
        return this.tracer.isEnabled() || this.meter.isEnabled();
    }
}

